/*
 * Decompiled with CFR 0.152.
 */
package ac.dashboard.reportrole;

import ac.analysis.AnalyzeEngine;
import ac.analysis.RoleIterator;
import ac.dashboard.reportrole.DashboardRoleSettings;
import ac.dashboard.reportrole.RoleReportListener;
import ac.dashboard.reportrole.RoleViolationAnalyzer;
import ac.risk.Risk;
import cn.Arguments;
import cn.Config;
import cn.DB;
import cn.Log;
import cn.task.Task;

public class RoleAnalysis {
    public static String getExecutionString() {
        return Config.getJavaStandardIncludes() + " ac/dashboard/reportrole/RoleAnalysis ";
    }

    public static void main(String[] args) {
        Arguments myArgs = Arguments.handle(args);
        Task task = Task.getById(myArgs.getInt("taskid"));
        DashboardRoleSettings settings = new DashboardRoleSettings(task.system, task.client);
        if (settings.doAnalysis()) {
            Risk[] risks = Risk.getActiveReportRisks(settings.reportParams);
            Log.log("Loading dummy users for role report.");
            RoleIterator analysisIterator = new RoleIterator(settings.reportParams);
            Log.log("Creating engine.");
            AnalyzeEngine engine = new AnalyzeEngine(risks, analysisIterator);
            Log.log("Creating role calculations listener.");
            RoleViolationAnalyzer drl = new RoleViolationAnalyzer(task.system, task.client);
            engine.addListener(drl);
            boolean isPartial = false;
            RoleReportListener.deleteOldReports(task.system, task.client);
            if (settings.makeReport()) {
                Log.log("Adding report listener.");
                RoleReportListener reportListener = new RoleReportListener(task, settings.reportParams);
                engine.addListener(reportListener);
                engine.analyze();
                RoleReportListener.translateReports(task, settings);
            } else {
                Log.log("NOT adding report listener due to Nightly Job settings where report is turned off.");
                engine.analyze();
            }
            DB.close();
            Log.close();
            if (settings.reportParams.isExcel() && isPartial) {
                System.exit(2);
            }
            if (engine.isLowMemory()) {
                System.exit(3);
            }
            System.exit(0);
        } else {
            Log.log("Role analysis is turned off in AC settings.");
            Log.log("Role analysis can be turned back on in AC Settings->Nightly job.");
            DB.close();
            Log.close();
            System.exit(0);
        }
    }

    public static String getBaseFilename(String system, String client) {
        StringBuilder sb = new StringBuilder();
        sb.append("AC_RoleCompliance");
        sb.append('_');
        sb.append(system);
        sb.append('_');
        sb.append(client);
        sb.append('_');
        return sb.toString();
    }
}

