/*
 * Decompiled with CFR 0.152.
 */
package ac.dashboard.legacyanalysis;

import ac.Workflow;
import ac.dashboard.ViolationLegacy;
import ac.risk.Risk;
import cn.DB;
import cn.Frequency;
import cn.Log;
import cn.SapUser;
import cn.Utils;
import java.sql.Date;
import java.sql.Timestamp;

class WorkflowAutoStarter {
    static int nullWorkflows = 0;

    WorkflowAutoStarter() {
    }

    void checkWorkflow(Risk risk, SapUser user, boolean approved, String handle, int legacy_id) {
        if (Utils.isEmpty(handle)) {
            Workflow.autoStartWorkFlow(user, legacy_id, risk, handle);
        } else {
            Workflow workflow = Workflow.getWorkflowFromHandle(handle);
            if (workflow != null) {
                if (risk.workflow_frequency != 9 && !workflow.isPending()) {
                    Date last_dateTime = new Date(Timestamp.valueOf(workflow.latest_approval == null ? workflow.timestamp : workflow.latest_approval).getTime());
                    Date last_rejected = new Date(Timestamp.valueOf(workflow.getLastRejected()).getTime());
                    Frequency frequency = new Frequency(risk.workflow_frequency);
                    frequency.findTimePeriod(last_dateTime);
                    if (last_rejected.compareTo(last_dateTime) > 0) {
                        if (Frequency.isOverdue(last_rejected, 3)) {
                            Log.log("Found last rejection " + last_rejected.toString() + " was last month so restart workflow.");
                            Workflow.autoStartWorkFlow(user, legacy_id, risk, handle);
                        }
                    } else if (frequency.isOverdue(last_dateTime)) {
                        Log.log("Found overdue last datetime " + last_dateTime.toString() + " with frequency " + Frequency.getFrequencyAsText(risk.workflow_frequency) + " (handle: " + handle + ")");
                        if (approved) {
                            Risk.disApproveForRisk(risk.id, user);
                        }
                        Workflow.autoStartWorkFlow(user, legacy_id, risk, handle);
                    }
                }
            } else if (workflow == null) {
                Log.log("WorkflowAutoStarter found handle '" + handle + "' for violation " + legacy_id + " but where workflow is NULL. Resetting handle and starting workflow.");
                ++nullWorkflows;
                handle = null;
                Workflow.autoStartWorkFlow(user, legacy_id, risk, handle);
            }
        }
    }

    static void autoCancelIrrelevantWorkflows(String system, String client) {
        String sql = "UPDATE sod_workflow SET `status` = 'auto_cancelled' WHERE `status` = 'pending' AND `system` = '" + system + "' AND `client` = '" + client + "' AND `violation_id` IS NOT NULL AND `violation_id` NOT IN (SELECT `id` FROM `" + ViolationLegacy.getLegacyTableName(system, client) + "`);";
        int affectedRows = DB.update(sql);
        Log.log("WorkflowAutoStarter auto cancelled " + affectedRows + " workflows because the violation no longer exists.");
    }
}

