/*
 * Decompiled with CFR 0.152.
 */
package ac.dashboard.legacyanalysis;

import ac.dashboard.DashboardUserSettings;
import ac.risk.Risk;
import cn.Config;
import cn.DB;
import cn.Language;
import cn.Log;
import cn.Translator;
import cn.report.Spreadsheet;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.sql.ResultSet;
import java.sql.SQLException;

class RiskOccurenceDocuments {
    RiskOccurenceDocuments() {
    }

    public static void createNewDocuments(String system, String client) {
        Log.log("AnalyzeRiskOccurrence (6/6) - analyzing data");
        String[][] reportData = new String[20][12];
        ResultSet result = DB.getData("SELECT * FROM sod_dashboard_topfiverisks WHERE sod_dashboard_topfiverisks.system = '" + system + "' AND sod_dashboard_topfiverisks.client = '" + client + "' ORDER BY sod_dashboard_topfiverisks.date DESC LIMIT 1; ");
        try {
            while (result.next()) {
                for (int i = 0; i < 20; ++i) {
                    int count = result.getInt("count" + i);
                    int risk_id = result.getInt("risk" + i);
                    if (count <= 0) continue;
                    ResultSet riskdata = DB.getData("SELECT \tsod_rule.*, \tsod_warning_types.type, \tsod_group.name AS groupname, \tsod_approvers.approver FROM sod_rule \tLEFT JOIN sod_group ON sod_group.id = sod_rule.group_id \tLEFT JOIN sod_approvers ON sod_approvers.id = sod_rule.approver_id \tJOIN sod_warning_types ON sod_warning_types.id = sod_rule.warning_id WHERE sod_rule.id = '" + risk_id + "'; ");
                    while (riskdata.next()) {
                        reportData[i][0] = "" + count;
                        reportData[i][1] = Risk.formatId(risk_id);
                        reportData[i][2] = riskdata.getString("name");
                        reportData[i][3] = riskdata.getString("description").replace("\n", " ").replace("\r", " ");
                        reportData[i][4] = riskdata.getString("mitigation").replace("\n", " ").replace("\r", " ");
                        reportData[i][5] = riskdata.getString("type");
                        reportData[i][6] = riskdata.getString("risk_level");
                        reportData[i][7] = riskdata.getInt("approver_id") > 0 ? riskdata.getString("approver") : "";
                        reportData[i][8] = Risk.riskTypeLookUp(riskdata.getString("rule_type"));
                        reportData[i][9] = riskdata.getString("groupname");
                        reportData[i][10] = riskdata.getString("origin");
                        reportData[i][11] = riskdata.getString("group_id");
                    }
                    riskdata.close();
                }
            }
            result.close();
        }
        catch (SQLException e) {
            Log.log("RiskOccurenceDocuments createNewDocuments getting data FAILED!");
            Log.logException(e);
        }
        Log.log("AnalyzeRiskOccurrence (6/6) - starting documents");
        String[] headers = new String[]{"Assigned risks", "Risk ID", "Name", "Description", "Mitigation description", "System reaction", "Level", "Approver", "Risk type", "Group", "Origin"};
        DashboardUserSettings dus = new DashboardUserSettings(system, client);
        for (Language language : Language.getAvailableLanguages()) {
            if (!dus.isLanguageActive(language.isoString)) continue;
            Translator translator = Translator.getInstance(language.isoString);
            Log.log("Translating content for document for language " + language.title);
            String[][] translatedData = new String[20][11];
            for (int i = 0; i < 20; ++i) {
                for (int j = 0; j < 12; ++j) {
                    if (reportData[i][0] == null) continue;
                    if (j == 8 || j == 6 || j == 5) {
                        translatedData[i][j] = translator.getText(reportData[i][j]);
                        continue;
                    }
                    if (j == 9 && reportData[i][11].contentEquals("0")) {
                        translatedData[i][j] = translator.getText(reportData[i][j]);
                        continue;
                    }
                    if (j == 11) continue;
                    translatedData[i][j] = reportData[i][j];
                }
            }
            Log.log("Creating document for language " + language.title);
            Spreadsheet ss = new Spreadsheet(translator);
            ss.addSheet("Data");
            ss.writeHeaders(headers);
            for (String[] content : translatedData) {
                ss.writeRow(content);
            }
            ss.addAutoFilter(headers.length);
            String filename = RiskOccurenceDocuments.getFilenameForDashboardDocument(system, client, language.isoString);
            ss.save(filename);
            Log.log("AnalyzeRiskOccurrence (6/6) - saved " + filename);
        }
    }

    public static void deleteOldDocuments(String system, String client) {
        for (Language language : Language.getAvailableLanguages()) {
            String filename = RiskOccurenceDocuments.getFilenameForDashboardDocument(system, client, language.isoString);
            Log.log("RiskOccurenceDocuments.deleteOldDocuments(" + system + "," + client + ") will look for '" + filename + "'.");
            File fd = new File(filename);
            try {
                Path fp = fd.toPath();
                if (Files.deleteIfExists(fp)) {
                    Log.log("Deleted " + filename);
                    continue;
                }
                Log.log("Did not find " + filename + " to delete.");
            }
            catch (Exception e) {
                Log.log("RiskOccurenceDocuments deleteOldDocuments FAILED!");
                Log.logException(e);
            }
        }
    }

    private static String getFilenameForDashboardDocument(String system, String client, String language) {
        return Config.getReportPath() + "AC_RiskFrequency-" + system + "_" + client + "-" + language + ".xlsx";
    }
}

