/*
 * Decompiled with CFR 0.152.
 */
package ac.dashboard.legacyanalysis;

import ac.dashboard.ViolationLegacy;
import ac.dashboard.legacyanalysis.AnalyzeUserLegacy;
import ac.dashboard.legacyanalysis.CountApprovedMitigated;
import ac.dashboard.legacyanalysis.CountMostOccuringRisks;
import ac.dashboard.legacyanalysis.CountReactionWarnings;
import ac.dashboard.legacyanalysis.CountRiskPerGroup;
import ac.dashboard.legacyanalysis.CountUserRisks;
import ac.dashboard.legacyanalysis.RiskOccurenceDocuments;
import ac.dashboard.legacyanalysis.WorkflowAutoStarter;
import ac.notification.NotificationTaskHandler;
import ac.risk.Risk;
import cn.Arguments;
import cn.DB;
import cn.Log;
import cn.Memory;
import cn.SapUser;
import cn.Utils;
import cn.task.Task;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class DataAnalysis {
    public static void main(String[] args) {
        Arguments myArgs = Arguments.handle(args);
        Task task = Task.getById(myArgs.getInt("taskid"));
        Log.log("Starting dashboard analysis for " + task.system + " / " + task.client);
        String legacyTable = ViolationLegacy.getLegacyTableName(task.system, task.client);
        int[] ids = DB.getOneNumberColumn("SELECT id FROM " + legacyTable);
        long numberOfViolations = ids.length;
        Log.log("Found " + ids.length + " legacy violations to analyze");
        CountApprovedMitigated countApprovedMitigated = new CountApprovedMitigated();
        CountReactionWarnings countReactionWarnings = new CountReactionWarnings();
        CountMostOccuringRisks countMostOccuringRisks = new CountMostOccuringRisks();
        CountRiskPerGroup countRiskPerGroup = new CountRiskPerGroup();
        CountUserRisks countUserRisks = new CountUserRisks();
        WorkflowAutoStarter workflowAutoStarter = new WorkflowAutoStarter();
        task.setName("Analyzing data");
        int[][] chunks = Utils.chunk(ids, 1000);
        int i = 0;
        ids = null;
        for (int j = 0; j < chunks.length; ++j) {
            int[] chunk = chunks[j];
            if (!Memory.ok4Analysis()) {
                Log.log("Trouble with available memory on chunk " + j + ". This should be handled!!! ..but as for right now we just BREAK!");
                break;
            }
            ResultSet rs = DB.getData("SELECT risk_id, user_id, approved, preventive_check_handle, id FROM `" + legacyTable + "` WHERE id IN (" + StringUtils.join((Object[])ArrayUtils.toObject((int[])chunk), (String)",") + "); ");
            try {
                while (rs.next()) {
                    Risk risk = Risk.getById(rs.getInt(1));
                    SapUser user = SapUser.getById(rs.getInt(2));
                    boolean approved = rs.getBoolean(3);
                    if (risk != null) {
                        countApprovedMitigated.count(risk, approved);
                        countReactionWarnings.count(risk);
                        countMostOccuringRisks.count(risk);
                        countRiskPerGroup.count(risk);
                        countUserRisks.count(risk, user.getUserName());
                        if (risk.isAutoWorkflow) {
                            workflowAutoStarter.checkWorkflow(risk, user, approved, rs.getString(4), rs.getInt(5));
                        }
                        ++i;
                        continue;
                    }
                    Log.log("RISK IS NULL for r: '" + rs.getInt("risk_id") + "' u: '" + rs.getInt("user_id") + "' ");
                }
                Log.log(Memory.statement("Analyzed " + i + " ; " + numberOfViolations + " violations. Chunk " + j + " ; " + chunks.length));
                rs.close();
                continue;
            }
            catch (SQLException e) {
                Log.log("ac.dashboard.DataAnalysis go() failed! Error code: " + e.getErrorCode());
                Log.logException(e);
            }
        }
        Log.log(Memory.statement("Analyzed " + i + " ; " + numberOfViolations + " violations in " + chunks.length + " chunks."));
        Log.log(Memory.statement("WorkflowAutoStarter found " + WorkflowAutoStarter.nullWorkflows + " NULL workflows."));
        WorkflowAutoStarter.autoCancelIrrelevantWorkflows(task.system, task.client);
        countApprovedMitigated.saveData(task.system, task.client);
        countReactionWarnings.saveData(task.system, task.client);
        Log.log(Memory.statement("AnalyzeRiskOccurrence (1/5) - setRiskGrouping - Defined Risks per Group"));
        countRiskPerGroup.saveRiskGrouping(task.system, task.client);
        Log.log(Memory.statement("AnalyzeRiskOccurrence (2/5) - setRiskStats - Top 20 risks"));
        countMostOccuringRisks.saveData(task.system, task.client);
        Log.log(Memory.statement("AnalyzeRiskOccurrence (3/5) - setRiskOccurrenceStats - Risk per Group"));
        countRiskPerGroup.saveData(task.system, task.client);
        Log.log(Memory.statement("AnalyzeRiskOccurrence (4/6) - findCriticalTcodeUsage now in separate job"));
        task.setName("Risk occurrence document");
        Log.log(Memory.statement("AnalyzeRiskOccurrence (5/5) - deleteOldDocuments"));
        RiskOccurenceDocuments.deleteOldDocuments(task.system, task.client);
        Log.log(Memory.statement("AnalyzeRiskOccurrence (6/5) - createRiskOccurrenceDocument"));
        RiskOccurenceDocuments.createNewDocuments(task.system, task.client);
        task.setName("Dashboard user analysis");
        Log.log(Memory.statement("Dashboard user analyzer (1/3) UserRisksStats"));
        countUserRisks.saveData(task.system, task.client);
        Log.log(Memory.statement("Dashboard user analyzer (2/3) TopTwentyUsers"));
        countUserRisks.saveTop20Data(task.system, task.client);
        Log.log(Memory.statement("Dashboard user analyzer (3/3) UsersStats"));
        countUserRisks.saveUserStats(task.system, task.client);
        AnalyzeUserLegacy.removeUnusedApprovals(task.system, task.client);
        Log.log(Memory.statement("sending pending legacy emails"));
        NotificationTaskHandler.main(args);
        Log.log(Memory.statement("Ending dashboard analysis for " + task.system + " / " + task.client));
        DB.close();
        Log.close();
    }
}

