/*
 * Decompiled with CFR 0.152.
 */
package ac.dashboard.legacyanalysis;

import ac.dashboard.DashboardUserSettings;
import ac.risk.Risk;
import cn.DB;
import cn.Log;
import cn.Utils;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class CountUserRisks {
    private final HashMap<Integer, ArrayList<String>> usersPerGroupSodFunc = new HashMap();
    private final HashMap<Integer, ArrayList<String>> usersPerGroupSodRole = new HashMap();
    private final HashMap<Integer, ArrayList<String>> usersPerGroupCritTcode = new HashMap();
    private final HashMap<Integer, ArrayList<String>> usersPerGroupCritRole = new HashMap();
    private final ArrayList<String> userTop20 = new ArrayList();
    private static Comparator<Map.Entry<String, Long>> valueComparator = new Comparator<Map.Entry<String, Long>>(){

        @Override
        public int compare(Map.Entry<String, Long> e1, Map.Entry<String, Long> e2) {
            int v1 = e1.getValue().intValue();
            int v2 = e2.getValue().intValue();
            return v2 - v1;
        }
    };

    CountUserRisks() {
    }

    public void count(Risk risk, String username) {
        this.userTop20.add(username);
        switch (risk.type) {
            case "crit_role": {
                if (this.usersPerGroupCritRole.containsKey(risk.group_id)) {
                    ArrayList<String> userList = this.usersPerGroupCritRole.get(risk.group_id);
                    userList.add(username);
                    break;
                }
                ArrayList<String> userList = new ArrayList<String>();
                userList.add(username);
                this.usersPerGroupCritRole.put(risk.group_id, userList);
                break;
            }
            case "sod_role2": {
                if (this.usersPerGroupSodRole.containsKey(risk.group_id)) {
                    ArrayList<String> userList = this.usersPerGroupSodRole.get(risk.group_id);
                    userList.add(username);
                    break;
                }
                ArrayList<String> userList = new ArrayList<String>();
                userList.add(username);
                this.usersPerGroupSodRole.put(risk.group_id, userList);
                break;
            }
            case "crit_tcode": {
                if (this.usersPerGroupCritTcode.containsKey(risk.group_id)) {
                    ArrayList<String> userList = this.usersPerGroupCritTcode.get(risk.group_id);
                    userList.add(username);
                    break;
                }
                ArrayList<String> userList = new ArrayList<String>();
                userList.add(username);
                this.usersPerGroupCritTcode.put(risk.group_id, userList);
                break;
            }
            case "sod_func": {
                if (this.usersPerGroupSodFunc.containsKey(risk.group_id)) {
                    ArrayList<String> userList = this.usersPerGroupSodFunc.get(risk.group_id);
                    userList.add(username);
                    break;
                }
                ArrayList<String> userList = new ArrayList<String>();
                userList.add(username);
                this.usersPerGroupSodFunc.put(risk.group_id, userList);
            }
        }
    }

    public void saveData(String system, String client) {
        CountUserRisks.savePerGroupWeighted(this.usersPerGroupSodFunc, "sod_func", system, client);
        CountUserRisks.savePerGroupWeighted(this.usersPerGroupSodRole, "sod_role2", system, client);
        CountUserRisks.savePerGroupWeighted(this.usersPerGroupCritTcode, "crit_tcode", system, client);
        CountUserRisks.savePerGroupWeighted(this.usersPerGroupCritRole, "crit_role", system, client);
        CountUserRisks.savePerGroup(this.usersPerGroupSodFunc, "sod_func", system, client);
        CountUserRisks.savePerGroup(this.usersPerGroupSodRole, "sod_role2", system, client);
        CountUserRisks.savePerGroup(this.usersPerGroupCritTcode, "crit_tcode", system, client);
        CountUserRisks.savePerGroup(this.usersPerGroupCritRole, "crit_role", system, client);
    }

    private static void savePerGroup(HashMap<Integer, ArrayList<String>> data, String type, String system, String client) {
        DB.update("DELETE FROM sod_dashboard_groupcount_users WHERE date=CURDATE() AND rule_type = '" + type + "' AND `system` = '" + system + "' AND client = '" + client + "';");
        PreparedStatement usersPergroup = DB.prepareStatement("INSERT IGNORE INTO sod_dashboard_groupcount_users \t(date, `system`, client, rule_type, group_id, count) VALUES\t(CURDATE(), ?, ?, ?, ?, ?) AS myData ON DUPLICATE KEY UPDATE count = myData.count;");
        if (data.size() > 0) {
            Log.log("CountUserRisks savePerGroup " + type + " saving " + data.size() + " groups.");
            for (Map.Entry<Integer, ArrayList<String>> entry : data.entrySet()) {
                try {
                    usersPergroup.setString(1, system);
                    usersPergroup.setString(2, client);
                    usersPergroup.setString(3, type);
                    usersPergroup.setInt(4, entry.getKey());
                    usersPergroup.setInt(5, Utils.countUnique((Collection)entry.getValue()));
                    usersPergroup.addBatch();
                }
                catch (SQLException e) {
                    Log.log("CountUsersPerGroup failed to fill in empty values for " + type);
                    Log.logException(e);
                }
            }
        } else {
            Log.log("CountUserRisks savePerGroup " + type + " saving 0 groups.");
            try {
                usersPergroup.setString(1, system);
                usersPergroup.setString(2, client);
                usersPergroup.setString(3, type);
                usersPergroup.setInt(4, -1);
                usersPergroup.setInt(5, 0);
                usersPergroup.addBatch();
            }
            catch (SQLException e) {
                Log.log("CountUsersPerGroup failed to fill in empty values for " + type);
                Log.logException(e);
            }
        }
        try {
            Log.log("CountUserRisks savePerGroup " + type + " executeUpdate .");
            usersPergroup.executeBatch();
        }
        catch (SQLException e) {
            Log.log("CountUsersPerGroup failed to execute batch for " + type);
            Log.logException(e);
        }
    }

    private static void savePerGroupWeighted(HashMap<Integer, ArrayList<String>> data, String type, String system, String client) {
        DB.update("DELETE FROM sod_dashboard_groupcount_users_weighted WHERE date=CURDATE() AND rule_type = '" + type + "' AND `system` = '" + system + "' AND client = '" + client + "';");
        PreparedStatement usersPerGroupWeighted = DB.prepareStatement("INSERT IGNORE INTO sod_dashboard_groupcount_users_weighted \t(date, `system`, client, rule_type, group_id, count) VALUES\t(CURDATE(), ?, ?, ?, ?, ?) AS myData ON DUPLICATE KEY UPDATE count = myData.count;");
        if (data.size() > 0) {
            Log.log("CountUserRisks savePerGroupWeighted " + type + " saving " + data.size() + " groups.");
            for (Map.Entry<Integer, ArrayList<String>> entry : data.entrySet()) {
                try {
                    usersPerGroupWeighted.setString(1, system);
                    usersPerGroupWeighted.setString(2, client);
                    usersPerGroupWeighted.setString(3, type);
                    usersPerGroupWeighted.setInt(4, entry.getKey());
                    usersPerGroupWeighted.setInt(5, entry.getValue().size());
                    usersPerGroupWeighted.addBatch();
                }
                catch (SQLException e) {
                    Log.log("savePerGroupWeighted failed to fill in empty values for " + type);
                    Log.logException(e);
                }
            }
        } else {
            Log.log("CountUserRisks savePerGroupWeighted " + type + " saving 0 groups.");
            try {
                usersPerGroupWeighted.setString(1, system);
                usersPerGroupWeighted.setString(2, client);
                usersPerGroupWeighted.setString(3, type);
                usersPerGroupWeighted.setInt(4, -1);
                usersPerGroupWeighted.setInt(5, 0);
                usersPerGroupWeighted.addBatch();
            }
            catch (SQLException e) {
                Log.log("CountUsersPerGroupWeighted failed to fill in empty values for " + type);
                Log.logException(e);
            }
        }
        try {
            Log.log("CountUserRisks savePerGroupWeighted " + type + " executeUpdate .");
            usersPerGroupWeighted.executeBatch();
        }
        catch (SQLException e) {
            Log.log("CountUsersPerGroupWeighted failed to execute batch for " + type);
            Log.logException(e);
        }
    }

    public void saveUserStats(String system, String client) {
        DashboardUserSettings dus = new DashboardUserSettings(system, client);
        String sql = "SELECT COUNT(id) AS total FROM um_user WHERE `system` = '" + system + "' AND client = '" + client + "' AND um_delete=0 ";
        if (dus.reportParams.excludeUsersLocked()) {
            sql = sql + "AND IFNULL(um_user.locked, 'U') <> 'L' ";
        }
        if (dus.reportParams.excludeUsersExpired()) {
            sql = sql + "AND (um_user.valid_to IS NULL OR um_user.valid_to >= CURDATE() OR um_user.valid_to = '0000-00-00') ";
        }
        int numberOfUsersInSystem = DB.getOneInt(sql);
        Log.log("Dashboard user analyzer (3/3) Number of users in system: " + numberOfUsersInSystem);
        int numberOfUsers = Utils.countUnique(this.userTop20);
        Log.log("Dashboard user analyzer (3/3) Users found with violations: " + numberOfUsers);
        int crit_role = CountUserRisks.countUsers(this.usersPerGroupCritRole);
        int sod_role2 = CountUserRisks.countUsers(this.usersPerGroupSodRole);
        int crit_tcode = CountUserRisks.countUsers(this.usersPerGroupCritTcode);
        int sod_func = CountUserRisks.countUsers(this.usersPerGroupSodFunc);
        Log.log("Dashboard user analyzer (3/3) CriticalRole: " + crit_role + "\t SoDRole: " + sod_role2 + "\t CriticalTcode: " + crit_tcode + "\t SoDfunctionality: " + sod_func);
        String userCount = "INSERT INTO sod_dashboard_usercount \n\t(`date`, `system`, `client`, total_users_in_system, total_user_in_violation, crit_role, sod_role2, crit_tcode, sod_func, sod_role) \nVALUES \t(CURDATE(), '" + system + "', '" + client + "', " + numberOfUsersInSystem + ", " + numberOfUsers + ", " + crit_role + ", " + sod_role2 + ", " + crit_tcode + ", " + sod_func + ", 0)  AS myData \nON DUPLICATE KEY UPDATE \n\ttotal_users_in_system = myData.total_users_in_system, \n\ttotal_user_in_violation = myData.total_user_in_violation, \n\tcrit_role = myData.crit_role, \n\tsod_role2 = myData.sod_role2, \n\tcrit_tcode = myData.crit_tcode, \n\tsod_func = myData.sod_func, \n\tsod_role = myData.sod_role;";
        Log.log("Update statement:\n" + userCount);
        DB.update(userCount);
        Log.log("Dashboard user analyzer (3/3) UserStats saved - partial flag is set for SoD analysis if partial.");
    }

    private static int countUsers(HashMap<Integer, ArrayList<String>> data) {
        int i = 0;
        for (Map.Entry<Integer, ArrayList<String>> entry : data.entrySet()) {
            i += entry.getValue().size();
        }
        return i;
    }

    public void saveTop20Data(String system, String client) {
        Map<String, Long> counts = this.userTop20.stream().collect(Collectors.groupingBy(e -> e, Collectors.counting()));
        ArrayList<Map.Entry<String, Long>> listOfEntries = new ArrayList<Map.Entry<String, Long>>();
        listOfEntries.addAll(counts.entrySet());
        listOfEntries.sort(valueComparator);
        Log.log("Dashboard user analyzer (2/3) TopTwentyUsers found " + listOfEntries.size() + " users with violations.");
        if (listOfEntries.size() > 0) {
            List top20users = listOfEntries.size() >= 20 ? listOfEntries.subList(0, 20) : listOfEntries.subList(0, listOfEntries.size());
            PreparedStatement PS = DB.prepareStatement("INSERT INTO sod_dashboard_toptwentyusers (\tdate, `system`, client, \tuser0, count0, user1, count1, user2, count2, user3, count3, user4, count4, \tuser5, count5, user6, count6, user7, count7, user8, count8, user9, count9, \tuser10, count10, user11, count11, user12, count12, user13, count13, user14, count14, \tuser15, count15, user16, count16, user17, count17, user18, count18, user19, count19) VALUES (CURDATE(), ?, ?, ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ON DUPLICATE KEY UPDATE \tuser0 = VALUES(`user0`), count0 = VALUES(`count0`), user1 = VALUES(`user1`), count1 = VALUES(`count1`), \tuser2 = VALUES(`user2`), count2 = VALUES(`count2`), user3 = VALUES(`user3`), count3 = VALUES(`count3`), \tuser4 = VALUES(`user4`), count4 = VALUES(`count4`), user5 = VALUES(`user5`), count5 = VALUES(`count5`), \tuser6 = VALUES(`user6`), count6 = VALUES(`count6`), user7 = VALUES(`user7`), count7 = VALUES(`count7`), \tuser8 = VALUES(`user8`), count8 = VALUES(`count8`), user9 = VALUES(`user9`), count9 = VALUES(`count9`), \tuser10 = VALUES(`user10`), count10 = VALUES(`count10`), user11 = VALUES(`user11`), count11 = VALUES(`count11`), \tuser12 = VALUES(`user12`), count12 = VALUES(`count12`), user13 = VALUES(`user13`), count13 = VALUES(`count13`), \tuser14 = VALUES(`user14`), count14 = VALUES(`count14`), user15 = VALUES(`user15`), count15 = VALUES(`count15`), \tuser16 = VALUES(`user16`), count16 = VALUES(`count16`), user17 = VALUES(`user17`), count17 = VALUES(`count17`), \tuser18 = VALUES(`user18`), count18 = VALUES(`count18`), user19 = VALUES(`user19`), count19 = VALUES(`count19`);");
            int index = 0;
            try {
                PS.setString(++index, system);
                PS.setString(++index, client);
                for (Map.Entry entry : top20users) {
                    PS.setString(++index, (String)entry.getKey());
                    PS.setInt(++index, ((Long)entry.getValue()).intValue());
                }
                if (index < 42) {
                    while (index < 42) {
                        PS.setString(++index, "");
                        PS.setInt(++index, 0);
                    }
                }
            }
            catch (SQLException e2) {
                Log.log("CountUsersTop20 setting db values failed!");
                Log.logException(e2);
            }
            try {
                PS.execute();
            }
            catch (SQLException e3) {
                Log.log("CountUsersTop20 executing prepared statement FAILED!");
                Log.logException(e3);
            }
        } else {
            Log.log("CountUsersTop20 found no users with violations.");
        }
    }
}

