/*
 * Decompiled with CFR 0.152.
 */
package ac.dashboard.legacyanalysis;

import ac.risk.Risk;
import cn.DB;
import cn.Log;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

class CountRiskPerGroup {
    private final HashMap<Integer, Integer> riskPerGroupSodFunc = new HashMap();
    private final HashMap<Integer, Integer> riskPerGroupSodRole = new HashMap();
    private final HashMap<Integer, Integer> riskPerGroupCritTcode = new HashMap();
    private final HashMap<Integer, Integer> riskPerGroupCritRole = new HashMap();

    CountRiskPerGroup() {
    }

    public void count(Risk risk) {
        switch (risk.type) {
            case "crit_role": {
                if (this.riskPerGroupCritRole.containsKey(risk.group_id)) {
                    int newValue = this.riskPerGroupCritRole.get(risk.group_id) + 1;
                    this.riskPerGroupCritRole.replace(risk.group_id, newValue);
                    break;
                }
                this.riskPerGroupCritRole.put(risk.group_id, 1);
                break;
            }
            case "sod_role2": {
                if (this.riskPerGroupSodRole.containsKey(risk.group_id)) {
                    int newValue = this.riskPerGroupSodRole.get(risk.group_id) + 1;
                    this.riskPerGroupSodRole.replace(risk.group_id, newValue);
                    break;
                }
                this.riskPerGroupSodRole.put(risk.group_id, 1);
                break;
            }
            case "crit_tcode": {
                if (this.riskPerGroupCritTcode.containsKey(risk.group_id)) {
                    int newValue = this.riskPerGroupCritTcode.get(risk.group_id) + 1;
                    this.riskPerGroupCritTcode.replace(risk.group_id, newValue);
                    break;
                }
                this.riskPerGroupCritTcode.put(risk.group_id, 1);
                break;
            }
            case "sod_func": {
                if (this.riskPerGroupSodFunc.containsKey(risk.group_id)) {
                    int newValue = this.riskPerGroupSodFunc.get(risk.group_id) + 1;
                    this.riskPerGroupSodFunc.replace(risk.group_id, newValue);
                    break;
                }
                this.riskPerGroupSodFunc.put(risk.group_id, 1);
            }
        }
    }

    public void saveData(String system, String client) {
        CountRiskPerGroup.save(this.riskPerGroupSodFunc, "sod_func", system, client);
        CountRiskPerGroup.save(this.riskPerGroupSodRole, "sod_role2", system, client);
        CountRiskPerGroup.save(this.riskPerGroupCritTcode, "crit_tcode", system, client);
        CountRiskPerGroup.save(this.riskPerGroupCritRole, "crit_role", system, client);
        Log.log("Saving RiskOccurrenceStats done.");
    }

    private static void save(HashMap<Integer, Integer> data, String type, String system, String client) {
        DB.update("DELETE FROM sod_dashboard_groupcount WHERE date=CURDATE() AND rule_type = '" + type + "' AND  `system` = '" + system + "' AND client = '" + client + "' ;");
        PreparedStatement PS = DB.prepareStatement("INSERT IGNORE INTO sod_dashboard_groupcount \t\t(date, `system`, client, rule_type, group_id, count) VALUES (CURDATE(), ?, ?, ?, ?, ?) AS myData ON DUPLICATE KEY UPDATE count = myData.count;");
        if (data.size() > 0) {
            for (Map.Entry<Integer, Integer> riskPerGroup : data.entrySet()) {
                int group_id = riskPerGroup.getKey();
                int count = riskPerGroup.getValue();
                try {
                    PS.setString(1, system);
                    PS.setString(2, client);
                    PS.setString(3, "crit_role");
                    PS.setInt(4, group_id);
                    PS.setInt(5, count);
                    PS.addBatch();
                }
                catch (SQLException e) {
                    Log.log("Setting RiskOccurrenceStats failed for " + type);
                    Log.logException(e);
                }
            }
        } else {
            try {
                PS.setString(1, system);
                PS.setString(2, client);
                PS.setString(3, "crit_role");
                PS.setInt(4, 0);
                PS.setInt(5, -1);
                PS.addBatch();
            }
            catch (SQLException e) {
                Log.log("Setting RiskOccurrenceStats failed for " + type);
                Log.logException(e);
            }
        }
        try {
            PS.executeBatch();
        }
        catch (SQLException e) {
            Log.log("RiskOccurrenceStats executing batch failed for " + type);
            Log.logException(e);
        }
    }

    public void saveRiskGrouping(String system, String client) {
        for (String ruleType : Risk.getTypes()) {
            Log.log("Updating risk groups per type - " + ruleType);
            DB.update("INSERT INTO sod_dashboard_rulecount \t(`date`, `system`, `client`, `rule_type`, `group_id`, `count`) SELECT * FROM ( \tSELECT CURDATE() AS `date`, \t\t'" + system + "' AS `system`, \t\t'" + client + "' AS `client`, \t\t'" + ruleType + "' AS `rule_type`, \t\tid AS `group_id`, \t\t(SELECT COUNT(id) AS total FROM sod_rule WHERE \t\t\t`group_id` = sod_group.id AND `rule_type` = '" + ruleType + "' AND \t\t\t`status` = 'Active' AND `system` = '" + system + "' AND `client` = '" + client + "' \t\t) AS `count` \tFROM sod_group \tWHERE (rule_type = '" + ruleType + "' AND `system` = '" + system + "' AND client = '" + client + "') OR id = 0 ) AS tp ON DUPLICATE KEY UPDATE `date` = CURDATE(), `system` = '" + system + "', `client` = '" + client + "',\t`rule_type` = '" + ruleType + "', `group_id` = tp.group_id, `count` = tp.count; ");
        }
    }
}

