/*
 * Decompiled with CFR 0.152.
 */
package ac.dashboard.legacyanalysis;

import ac.report.RiskOutputHelper;
import ac.risk.Risk;
import cn.DB;
import cn.Log;
import java.sql.PreparedStatement;
import java.sql.SQLException;

class CountReactionWarnings {
    private final int[] warningReactionsCount;

    public CountReactionWarnings() {
        int[] wrs = RiskOutputHelper.getWarningReactions();
        this.warningReactionsCount = new int[wrs.length];
        for (int wr : wrs) {
            this.warningReactionsCount[wr] = 0;
        }
    }

    public void count(Risk risk) {
        int n = risk.warning;
        this.warningReactionsCount[n] = this.warningReactionsCount[n] + 1;
    }

    public void saveData(String system, String client) {
        Log.log("Saving user violation reaction types.");
        try {
            PreparedStatement ps = DB.prepareStatement("INSERT INTO sod_dashboard_reactioncount (`system`, client, warning_type_id, count) VALUES\t('" + system + "', '" + client + "', ?, ?) ON DUPLICATE KEY UPDATE count = ?; ");
            for (int warningtypeid = 0; warningtypeid < this.warningReactionsCount.length; ++warningtypeid) {
                int count = this.warningReactionsCount[warningtypeid];
                ps.setInt(1, warningtypeid);
                ps.setInt(2, count);
                ps.setInt(3, count);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            Log.log("Saving user violation reaction types FAILED!");
            Log.logException(e);
        }
        Log.log("User violation reaction types saved.\n");
    }
}

