/*
 * Decompiled with CFR 0.152.
 */
package ac.dashboard.legacyanalysis;

import ac.risk.Risk;
import cn.DB;
import cn.Log;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

class CountMostOccuringRisks {
    private final HashMap<Integer, Integer> riskOccurences = new HashMap();

    CountMostOccuringRisks() {
    }

    public void count(Risk risk) {
        if (this.riskOccurences.containsKey(risk.id)) {
            int newValue = this.riskOccurences.get(risk.id) + 1;
            this.riskOccurences.replace(risk.id, newValue);
        } else {
            this.riskOccurences.put(risk.id, 1);
        }
    }

    public void saveData(String system, String client) {
        PreparedStatement ps = DB.prepareStatement("INSERT IGNORE INTO sod_dashboard_topfiverisks \t(date, `system`, client, risk0, count0, risk1, count1, risk2, count2, risk3, count3, risk4, count4, \trisk5, count5, risk6, count6, risk7, count7, risk8, count8, risk9, count9, \trisk10, count10, risk11, count11, risk12, count12, risk13, count13, risk14, count14, \trisk15, count15, risk16, count16, risk17, count17, risk18, count18, risk19, count19) VALUES (CURDATE(), '" + system + "', '" + client + "', \t?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) AS myData ON DUPLICATE KEY UPDATE \trisk0 = myData.risk0, count0 = myData.count0, risk1 = myData.risk1, count1 = myData.count1, \trisk2 = myData.risk2, count2 = myData.count2, risk3 = myData.risk3, count3 = myData.count3, \trisk4 = myData.risk4, count4 = myData.count4, risk5 = myData.risk5, count5 = myData.count5, \trisk6 = myData.risk6, count6 = myData.count6, risk7 = myData.risk7, count7 = myData.count7, \trisk8 = myData.risk8, count8 = myData.count8, risk9 = myData.risk9, count9 = myData.count9, \trisk10= myData.risk10, count10= myData.count10, risk11= myData.risk11, count11= myData.count11, \trisk12= myData.risk12, count12= myData.count12, risk13= myData.risk13, count13= myData.count13, \trisk14= myData.risk14, count14= myData.count14, risk15= myData.risk15, count15= myData.count15, \trisk16= myData.risk16, count16= myData.count16, risk17= myData.risk17, count17= myData.count17, \trisk18= myData.risk18, count18= myData.count18, risk19= myData.risk19, count19= myData.count19;");
        HashMap<Integer, Integer> sortedByValue = CountMostOccuringRisks.sortHashMapByValue(this.riskOccurences);
        int index = 0;
        for (Map.Entry<Integer, Integer> riskOccurence : sortedByValue.entrySet()) {
            if (index >= 40) continue;
            try {
                ps.setInt(++index, riskOccurence.getKey());
                ps.setInt(++index, riskOccurence.getValue());
                Log.log("Setting " + riskOccurence.getKey() + "," + riskOccurence.getValue() + " at " + (index - 1) + "," + index);
            }
            catch (SQLException e) {
                Log.log("CountMostOccuringRisks creating prepared statement FAILED!");
                Log.logException(e);
            }
        }
        if (index < 40) {
            while (index < 40) {
                try {
                    ps.setInt(++index, -1);
                    ps.setInt(++index, 0);
                    Log.log("Setting -1, 0 at " + (index - 1) + "," + index);
                }
                catch (SQLException e) {
                    Log.log("CountMostOccuringRisks creating prepared statement with empty values FAILED!");
                    Log.logException(e);
                }
            }
        }
        try {
            Log.log("Executing update for top 20 risks.");
            ps.execute();
        }
        catch (SQLException e) {
            Log.log("CountMostOccuringRisks executing prepared statement FAILED!");
            Log.logException(e);
        }
        Log.log("Top 20 risks saved.");
    }

    private static HashMap<Integer, Integer> sortHashMapByValue(HashMap<Integer, Integer> hashmapToSort) {
        Comparator<Map.Entry<Integer, Integer>> valueComparator = new Comparator<Map.Entry<Integer, Integer>>(){

            @Override
            public int compare(Map.Entry<Integer, Integer> e1, Map.Entry<Integer, Integer> e2) {
                int v1 = e1.getValue();
                int v2 = e2.getValue();
                return v1 - v2;
            }
        };
        ArrayList<Map.Entry<Integer, Integer>> listOfEntries = new ArrayList<Map.Entry<Integer, Integer>>();
        listOfEntries.addAll(hashmapToSort.entrySet());
        Collections.sort(listOfEntries, valueComparator);
        HashMap<Integer, Integer> returnHashMap = new HashMap<Integer, Integer>();
        for (Map.Entry entry : listOfEntries) {
            returnHashMap.put((Integer)entry.getKey(), (Integer)entry.getValue());
        }
        return returnHashMap;
    }
}

