/*
 * Decompiled with CFR 0.152.
 */
package ac.dashboard.legacyanalysis;

import ac.dashboard.ViolationLegacy;
import cn.DB;
import cn.Log;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

class AnalyzeUserLegacy {
    static String legacyTable;
    private static final PreparedStatement PS_deleteUnusedApprovals;

    AnalyzeUserLegacy() {
    }

    public static void removeUnusedApprovals(String system, String client) {
        legacyTable = ViolationLegacy.getLegacyTableName(system, client);
        Log.log("Remove approvals that are no longer used in the table: " + legacyTable);
        try {
            ResultSet rs = DB.getData("SELECT sod_approved_user.* FROM sod_approved_user JOIN um_user ON um_user.user = sod_approved_user.username LEFT JOIN " + legacyTable + " ON " + legacyTable + ".user_id = um_user.id AND " + legacyTable + ".risk_id = sod_approved_user.risk_id WHERE sod_approved_user.system = '" + system + "' AND sod_approved_user.client = '" + client + "' AND um_user.system = '" + system + "' AND um_user.client = '" + client + "' AND " + legacyTable + ".id IS NULL;");
            Log.log("Found " + rs.getMetaData().getColumnCount() + " approvals that are no longer used.");
            while (rs.next()) {
                Log.log("Legacy Analyzer removing approval: risk id: " + rs.getInt("risk_id") + " for " + rs.getString("username") + " on " + system + " / " + client);
                try {
                    PS_deleteUnusedApprovals.setString(1, system);
                    PS_deleteUnusedApprovals.setString(2, client);
                    PS_deleteUnusedApprovals.setString(3, rs.getString("username"));
                    PS_deleteUnusedApprovals.setInt(4, rs.getInt("risk_id"));
                    PS_deleteUnusedApprovals.executeUpdate();
                }
                catch (Exception e) {
                    Log.log("removeUnusedApprovals Deletion of unused approvals failed");
                    Log.logException(e);
                }
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("removeUnusedApprovals Querry for unused approvals failed");
            Log.logException(e);
        }
        Log.log("Remove approvals done.");
    }

    static {
        PS_deleteUnusedApprovals = DB.prepareStatement("DELETE FROM sod_approved_user WHERE sod_approved_user.system = ? AND sod_approved_user.client = ? AND sod_approved_user.username = ? AND sod_approved_user.risk_id = ? ;");
    }
}

