/*
 * Decompiled with CFR 0.152.
 */
package ac.dashboard;

import ac.dashboard.DashboardSettings;
import ac.report.standard.Report;
import cn.Config;
import cn.Language;
import cn.Log;
import cn.Memory;
import cn.Translator;
import cn.Utils;
import cn.report.CSVfile;
import cn.report.CSVline;
import cn.task.Task;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;

public final class TranslateReport {
    private static final String TERMINATOR = "\";";
    private static String[] translationColumns = new String[]{"Risk type", "Risk level", "System reaction", "Origin", "Approved", "Reference User", "Lock Status"};

    public static void translateReport(Task task, String baseFilename, DashboardSettings settings) {
        Log.log(Memory.statement("Starting translation of dashboard role analysis reports."));
        String englishFile = Config.getReportPath() + baseFilename + "en.csv";
        ArrayList<CallSite> outputBuffer = new ArrayList<CallSite>();
        for (Language language : Language.getAvailableLanguages()) {
            if (settings.isLanguageActive(language.isoString) && !language.isoString.contentEquals("en")) {
                Log.log(Memory.statement("Translating to " + language.title));
                Translator translator = Translator.getInstance(language.isoString);
                settings.reportParams.setLanguageISO(language.isoString);
                CSVfile selectionsCSV = new CSVfile(baseFilename + language.isoString + "_selections.csv", true);
                CSVline selectionLines = new CSVline(selectionsCSV, 2);
                Report.makeSelectionSheet(translator, task, settings.reportParams, selectionLines);
                selectionsCSV.close();
                CSVfile contentCSV = new CSVfile(baseFilename + language.isoString + ".csv", true);
                int lineNumber = 0;
                ArrayList<Integer> columnsToTranslate = new ArrayList<Integer>();
                Log.log("Reading file.");
                try {
                    BufferedReader buffReader = Files.newBufferedReader(Paths.get(englishFile, new String[0]), StandardCharsets.UTF_8);
                    while (buffReader.ready()) {
                        String line = buffReader.readLine();
                        CharSequence[] lineContent = line.split(TERMINATOR);
                        if (lineNumber == 0) {
                            for (int i = 0; i < lineContent.length; ++i) {
                                String text = lineContent[i].replace("\"", "");
                                lineContent[i] = "\"" + translator.getText(text);
                                if (!TranslateReport.shouldBeTranslated(text)) continue;
                                columnsToTranslate.add(i);
                                Log.debug("Translator will translate column " + i + ", " + text);
                            }
                        } else {
                            Iterator iterator = columnsToTranslate.iterator();
                            while (iterator.hasNext()) {
                                int column = (Integer)iterator.next();
                                if (column < lineContent.length) {
                                    lineContent[column] = "\"" + translator.getText(((String)lineContent[column]).replace("\"", ""));
                                    continue;
                                }
                                Log.debug("Translator is trying to translate column " + column + ", but column does not exist. Line: " + line);
                            }
                        }
                        String data = String.join((CharSequence)TERMINATOR, lineContent) + "\";\n";
                        outputBuffer.add((CallSite)((Object)data));
                        if (++lineNumber % 50000 != 0) continue;
                        Log.log("Translated " + lineNumber + " lines. Writing... ");
                        CSVfile.writeDirectlyToFile(contentCSV, String.join((CharSequence)"", outputBuffer.toArray(Utils.EMPTYSTRINGARRAY)));
                        outputBuffer.clear();
                    }
                    buffReader.close();
                }
                catch (IOException e) {
                    Log.log("ac.dashboard.roleanalysis.TranslateReports FAILED to read file.");
                    Log.logException(e);
                }
                Log.log("Translated " + lineNumber + " lines. Writing... ");
                CSVfile.writeDirectlyToFile(contentCSV, String.join((CharSequence)"", outputBuffer.toArray(Utils.EMPTYSTRINGARRAY)));
                outputBuffer.clear();
                Log.log(Memory.statement("Closing csv file with " + lineNumber + " lines."));
                contentCSV.close();
                continue;
            }
            Log.log(Memory.statement("Skipping language " + language.title));
        }
    }

    private static boolean shouldBeTranslated(String text) {
        for (String s : translationColumns) {
            if (!s.contentEquals(text)) continue;
            return true;
        }
        return false;
    }
}

