/*
 * Decompiled with CFR 0.152.
 */
package ac.dashboard;

import ac.report.tools.Settings;
import cn.Config;
import cn.DB;
import cn.Language;

public abstract class DashboardSettings {
    public Settings reportParams;
    protected Language notificationLanguage = null;
    protected String[] activeLanguageCodes = null;

    protected DashboardSettings(String system, String client) {
        this.activeLanguageCodes = DashboardSettings.loadActiveLanguages(system, client);
        this.notificationLanguage = DashboardSettings.loadNotificationLanguage(system, client);
    }

    public boolean makeReport() {
        return this.reportParams.getBoolean("make_report");
    }

    public boolean doAnalysis() {
        return this.reportParams.getBoolean("doAnalysis");
    }

    public boolean isLanguageActive(String isocode) {
        if (isocode.equalsIgnoreCase(Config.getFallbackLanguageISO())) {
            return true;
        }
        for (String iso : this.activeLanguageCodes) {
            if (!iso.equalsIgnoreCase(isocode)) continue;
            return true;
        }
        return false;
    }

    private static String[] loadActiveLanguages(String system, String client) {
        return DB.getOneTextColumn("SELECT language_code FROM sod_dashboard_document_language WHERE `system` = '" + system + "' AND client = '" + client + "'; ");
    }

    private static Language loadNotificationLanguage(String system, String client) {
        String languageISO = DB.getOne("SELECT workflow_notifications_language FROM settings_sod WHERE `system` = '" + system + "' AND client = '" + client + "';");
        Language language = Language.getLanguage(languageISO);
        return language;
    }
}

