/*
 * Decompiled with CFR 0.152.
 */
package ac.dashboard;

import ac.risk.RiskCriticalTcodes;
import cn.Arguments;
import cn.DB;
import cn.Log;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import um.Usage;

public class CriticalTcodeSuddenUse {
    public static void main(String[] args) {
        Arguments myArgs = Arguments.handle(args);
        String system = myArgs.get("system");
        String client = myArgs.get("client");
        Log.log("Starting CriticalTcodeSuddenUse analysis for " + system + " / " + client);
        CriticalTcodeSuddenUse.calculate(system, client);
        Log.log("Ending CriticalTcodeSuddenUse analysis for " + system + " / " + client);
        DB.close();
        Log.close();
    }

    public static void calculate(String system, String client) {
        String usageTable = Usage.getUsageTable(system, client);
        if (DB.isTable(usageTable)) {
            PreparedStatement ps = DB.prepareStatement("INSERT IGNORE INTO sod_crit_tcode_monitor \t(user_id, tcode_id, date, last_date) VALUES(\t\t(\t\t\tSELECT id FROM um_user WHERE \t\t\t\t`system` = '" + system + "' AND client = '" + client + "' AND user = ? \t\t),\t\t( \t\t\tSELECT id FROM um_tcode WHERE \t\t\t\t`system` = '" + system + "' AND client = '" + client + "' AND tcode = ? \t\t),\t\t( \t\t\tSELECT date FROM `" + usageTable + "` WHERE \t\t\t\tuser = ? AND tcode = ? AND `date` <> '0000-00-00' \t\t\tORDER BY date DESC LIMIT 1 \t\t),\t\t( \t\t\tSELECT date FROM `" + usageTable + "` WHERE \t\t\t\tuser = ? AND tcode = ? AND date < (date_sub(now(), INTERVAL 2 DAY)) \t\t) ); ");
            Log.log("Getting active critical tcodes");
            String[] critTcodes = RiskCriticalTcodes.getActiveCritTcodes(system, client);
            Log.log("Analyzing active critical tcodes");
            PreparedStatement psUsers = DB.prepareStatement("SELECT `user` FROM `" + usageTable + "` WHERE \t`tcode` = ? AND \t`date` >= date_sub(now(), INTERVAL 3 DAY) AND `date` <= now() AND \t`user` NOT IN ( \t\tSELECT user FROM sod_crit_tcode_monitor \t\tJOIN um_user ON um_user.id = sod_crit_tcode_monitor.user_id \t\tWHERE \t\t`date` >= date_sub(now(), INTERVAL 3 DAY) AND `date` <= now() AND \t\t`tcode_id` = (\t\t\tSELECT id FROM um_tcode WHERE `system` = '" + system + "' AND `client` = '" + client + "' AND `tcode` = ?\t\t)\t);");
            PreparedStatement psCountUsage = DB.prepareStatement("SELECT (\tSELECT COUNT(user) FROM `" + usageTable + "` WHERE \tuser = ? AND tcode = ? AND \tdate >= date_sub(now(), INTERVAL 3 DAY) AND date <= now() ) AS recent, (\tSELECT COUNT(user) FROM `" + usageTable + "` WHERE \tuser = ? AND tcode = ? AND \tdate > date_sub(now(), INTERVAL 90 DAY) AND \tdate < date_sub(now(), INTERVAL 3 DAY) ) AS past; ");
            for (String tcode : critTcodes) {
                String[] usernames;
                try {
                    psUsers.setString(1, tcode);
                    psUsers.setString(2, tcode);
                }
                catch (SQLException e) {
                    Log.log("CriticalTcodeHighUsageCalculator failed to add tcode to prepared statement.");
                    Log.logException(e);
                }
                for (String username : usernames = DB.preparedStatementGetOneTextColumn(psUsers)) {
                    try {
                        psCountUsage.setString(1, username);
                        psCountUsage.setString(2, tcode);
                        psCountUsage.setString(3, username);
                        psCountUsage.setString(4, tcode);
                        ResultSet result = psCountUsage.executeQuery();
                        if (result.next() && result.getInt("recent") > 0 && result.getInt("past") == 0) {
                            Log.log("Critical Tcode monitored: " + username + "," + system + "," + client + "," + tcode);
                            ps.setString(1, username);
                            ps.setString(2, tcode);
                            ps.setString(3, username);
                            ps.setString(4, tcode);
                            ps.setString(5, username);
                            ps.setString(6, tcode);
                            ps.addBatch();
                        }
                        result.close();
                    }
                    catch (SQLException e) {
                        Log.log("CriticalTcodeHighUsageCalculator calculate FAILED!");
                        Log.logException(e);
                    }
                }
            }
            Log.log("CriticalTcodeHighUsageCalculator execute batch.");
            try {
                ps.executeBatch();
            }
            catch (SQLException e) {
                Log.log("CriticalTcodeHighUsageCalculator execute batch FAILED!");
                Log.logException(e);
            }
        } else {
            Log.log("NO USAGE available in '" + usageTable + "'.");
        }
        Log.log("CriticalTcodeHighUsageCalculator Done.");
    }
}

