/*
 * Decompiled with CFR 0.152.
 */
package ac.analysis;

import ac.analysis.AnalysisIterator;
import ac.analysis.AnalysisRole;
import ac.analysis.AnalysisUser;
import ac.analysis.OrgLevel;
import cn.DB;
import cn.Log;
import cn.Memory;
import cn.TaskParameters;
import cn.Utils;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class UserIterator
implements AnalysisIterator {
    private final DataSet[] userData;
    private final TaskParameters params;
    private final int totalUsers;
    private int index = 0;
    private long timeSpentgettingUsers = 0L;

    public UserIterator(TaskParameters params) {
        this.params = params;
        OrgLevel.loadOrgLevels(params.system, params.client);
        ArrayList<DataSet> data = new ArrayList<DataSet>();
        String totalStatement = UserIterator.getStatement(this.params);
        Log.log(Memory.statement("ac.report.tools.UserIterator statement:\n" + totalStatement));
        ArrayList<String> hashes = new ArrayList<String>();
        if (params.getStringArray("user").length > 0 && params.getUserIdsFromParams().length == 0) {
            Log.log(Memory.statement("ac.report.tools.UserIterator None of the specified users exist."));
        } else {
            ResultSet rs = DB.getData(totalStatement);
            try {
                while (rs.next()) {
                    String hash = rs.getString(2);
                    data.add(new DataSet(rs.getInt(1), hash));
                    if (Utils.isEmpty(hash)) continue;
                    hashes.add(hash);
                }
                rs.close();
            }
            catch (Exception e) {
                Log.log("UserIterator constructor loading user data FAILED!");
                Log.logException(e);
            }
        }
        this.userData = data.toArray(new DataSet[0]);
        this.totalUsers = this.userData.length;
        if (this.totalUsers > 0) {
            Log.log(Memory.statement("ac.report.tools.UserIterator created with " + this.totalUsers + " users."));
        } else {
            Log.log(Memory.statement("ac.report.tools.UserIterator created with NO USERS!"));
        }
        Log.log("Getting associated roles.");
        if (hashes.size() > 0) {
            String hashString = String.join((CharSequence)",", Utils.unique(hashes));
            Log.log("Getting associated roles from hash combination " + hashString);
            int[] role_ids = Utils.unique(Utils.getIdsFromString(hashString));
            Log.log(Memory.statement("Loading " + role_ids.length + " associated roles."));
            AnalysisRole.loadIds(role_ids, params.system, params.client);
            Log.log(Memory.statement("Loaded " + role_ids.length + " associated roles and authorizations."));
        } else {
            Log.log("NO USERS HAVE ANY ROLES TO LOAD!");
        }
    }

    @Override
    public final AnalysisUser nextUser() {
        long startTime = System.nanoTime();
        AnalysisUser au = AnalysisUser.getById(this.userData[this.index].user_id, this.userData[this.index].role_hash, this.params.system, this.params.client);
        if (++this.index % 1000 == 0) {
            Memory.statement("");
        }
        this.timeSpentgettingUsers += System.nanoTime() - startTime;
        return au;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.totalUsers;
    }

    @Override
    public int getTotal() {
        return this.totalUsers;
    }

    @Override
    public long getTimeSpentGettingUsers() {
        return TimeUnit.NANOSECONDS.toMillis(this.timeSpentgettingUsers);
    }

    public int[] getAllUserIds() {
        int[] user_ids = new int[this.userData.length];
        int i = 0;
        for (DataSet ds : this.userData) {
            user_ids[i++] = ds.user_id;
        }
        return user_ids;
    }

    private static String getStatement(TaskParameters params) {
        StringBuilder sql = new StringBuilder("SELECT \nDISTINCT(um_user.id) AS user_id, \nTRIM(GROUP_CONCAT(role_id  SEPARATOR ',')) AS role_hash, \nCOUNT(role_id) AS number_of_roles \nFROM um_user \nLEFT JOIN um_user_role ON um_user_role.user_id = um_user.id AND um_user_role.direct = 1 AND um_user_role.um_delete = 0 \nWHERE um_user.system = '" + params.system + "' AND um_user.client = '" + params.client + "' AND um_user.um_delete = 0 \n");
        if (params.getStringArray("user").length > 0) {
            sql.append("AND um_user.id IN (" + Utils.toQuotedString(params.getUserIdsFromParams()) + ") \n");
        } else {
            CharSequence[] userGroups = params.getStringArray("userGroup");
            CharSequence[] userTypes = params.getStringArray("userType");
            if (!Utils.isEmpty((String[])userGroups)) {
                sql.append("AND um_user.user_group IN ('" + String.join((CharSequence)"', '", userGroups) + "') \n");
            }
            if (!Utils.isEmpty((String[])userTypes)) {
                sql.append("AND um_user.type IN ('" + String.join((CharSequence)"', '", userTypes) + "') \n");
            }
            if (params.excludeUsersLocked()) {
                sql.append("AND IFNULL(um_user.locked, 'U') <> 'L' \n");
            }
            if (params.excludeUsersExpired()) {
                sql.append("AND (um_user.valid_to IS NULL OR um_user.valid_to >= CURDATE() OR um_user.valid_to = '0000-00-00') \n");
            }
        }
        sql.append("GROUP BY um_user.id ORDER BY number_of_roles ASC, role_hash ASC, um_user.ref_user ASC, um_user.user ASC, um_user_role.direct;");
        Log.log("UserIterator getStatement() [User selection and roles]:\n" + sql.toString());
        return sql.toString();
    }

    private final class DataSet {
        final int user_id;
        final String role_hash;

        DataSet(int user_id, String role_hash) {
            this.user_id = user_id;
            this.role_hash = role_hash;
        }
    }
}

