/*
 * Decompiled with CFR 0.152.
 */
package ac.analysis;

import ac.analysis.AnalysisIterator;
import ac.analysis.AnalysisRole;
import ac.analysis.AnalysisUser;
import ac.analysis.OrgLevel;
import cn.DB;
import cn.Log;
import cn.Memory;
import cn.Role;
import cn.TaskParameters;
import cn.Utils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;

public class RoleIterator
implements AnalysisIterator {
    private final TaskParameters params;
    private final int totalUsers;
    private static long timeSpentgettingUsers = 0L;
    private final int[] allRoleIds;
    private int index = 0;
    private static PreparedStatement PS_getNextRole;

    public RoleIterator(TaskParameters params) {
        this.params = params;
        OrgLevel.loadOrgLevels(params.system, params.client);
        if (params.getStringArray("role").length > 0) {
            this.allRoleIds = params.getRoleIds();
            Log.log(Memory.statement("ac.report.tools.RoleIterator has been given list of role ids: \n" + Utils.toQuotedString(this.allRoleIds)));
        } else {
            String sql = "SELECT DISTINCT(id) " + RoleIterator.getStatement(this.params) + " ORDER BY `role`;";
            Log.log(Memory.statement("ac.report.tools.RoleIterator finding role ids: \n" + sql));
            this.allRoleIds = DB.getOneNumberColumn(sql);
        }
        this.totalUsers = this.allRoleIds.length;
        Log.log(Memory.statement("ac.report.tools.RoleIterator expecting " + this.totalUsers + " roles."));
        PS_getNextRole = this.params.getBoolean("showRoleAssignment") ? DB.prepareStatement("SELECT `role`, `type`, `description`, `star_category_step`, (SELECT COUNT(user_id) FROM um_user_role WHERE role_id = id) AS assignments FROM um_role WHERE id = ?;") : DB.prepareStatement("SELECT `role`, `type`, `description`, `star_category_step`, -2 AS assignments FROM um_role WHERE id = ?;");
    }

    @Override
    public final AnalysisUser nextUser() {
        return RoleIterator.createDummyUser(this.allRoleIds[this.index++], this.params.system, this.params.client);
    }

    @Override
    public boolean hasNext() {
        return this.index < this.totalUsers;
    }

    @Override
    public int getTotal() {
        return this.totalUsers;
    }

    @Override
    public long getTimeSpentGettingUsers() {
        return TimeUnit.NANOSECONDS.toMillis(timeSpentgettingUsers);
    }

    private static final AnalysisUser createDummyUser(int role_id, String system, String client) {
        long startTime = System.nanoTime();
        try {
            PS_getNextRole.setInt(1, role_id);
            ResultSet rs = PS_getNextRole.executeQuery();
            if (rs.next()) {
                String rolename = rs.getString(1);
                String description = rs.getString(3);
                AnalysisRole role = new AnalysisRole(role_id, rolename, description == null ? "" : description, rs.getInt("star_category_step"), Role.isComposite(rs.getString(2)), system, client);
                role.assignments = rs.getInt(4);
                AnalysisUser au = new AnalysisUser(rolename, system, client, role);
                timeSpentgettingUsers += System.nanoTime() - startTime;
                return au;
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("ac.report.tools.RoleIterator Failed to read role data for dummy users.");
            Log.logException(e);
        }
        return null;
    }

    private static String getStatement(TaskParameters params) {
        String sql = "FROM um_role WHERE um_role.system = '" + params.system + "' AND um_role.client = '" + params.client + "' AND um_role.um_delete = 0 ";
        if (params.getStringArray("role").length > 0) {
            sql = sql + "AND um_role.id IN (" + Utils.toQuotedString(params.getRoleIds()) + ") ";
        } else {
            switch (params.getString("roleType")) {
                case "S": {
                    sql = sql + "AND um_role.type = 'S' ";
                    break;
                }
                case "C": {
                    sql = sql + "AND um_role.type = 'C' ";
                    break;
                }
                case "A": {
                    sql = sql + "AND id IN (SELECT role_id FROM um_user_role \tJOIN um_user AS u ON u.id = um_user_role.user_id AND u.um_delete = 0 \tWHERE \t\tum_user_role.system = '" + params.system + "' AND\t\t\tum_user_role.client = '" + params.client + "' AND \t\tum_user_role.um_delete = 0 AND \t    u.um_delete = 0 \t) ";
                    break;
                }
            }
        }
        return sql;
    }
}

