/*
 * Decompiled with CFR 0.152.
 */
package ac.analysis;

import ac.analysis.AuthObject;
import ac.analysis.Authorization;
import cn.Config;
import cn.DB;
import cn.Log;
import cn.Utils;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;

public class OrgLevel {
    private static boolean isLoaded = false;
    private static int[] monitoredFieldIds = null;
    private static int[] includedFieldIds;
    private static int[] orgLevelFieldIds;

    public static void setFieldsConsidered(String system, String client, int[] field_ids) {
        OrgLevel.loadOrgLevels(system, client);
        monitoredFieldIds = field_ids;
        Log.log("OrgLevel Organizational Levels monitored " + monitoredFieldIds.length + ".");
    }

    public static String[] getFieldNamesConsidered(String system, String client) {
        ArrayList<String> fieldnames = new ArrayList<String>();
        if (!isLoaded) {
            OrgLevel.loadOrgLevels(system, client);
        }
        for (int field_id : monitoredFieldIds) {
            fieldnames.add(AuthObject.getFieldById(field_id));
        }
        return fieldnames.toArray(Utils.EMPTYSTRINGARRAY);
    }

    public static String[] getFieldNamesIncludeEmpty(String system, String client) {
        ArrayList<String> fieldnames = new ArrayList<String>();
        if (!isLoaded) {
            OrgLevel.loadOrgLevels(system, client);
        }
        for (int field_id : includedFieldIds) {
            fieldnames.add(AuthObject.getFieldById(field_id));
        }
        return fieldnames.toArray(Utils.EMPTYSTRINGARRAY);
    }

    public static boolean isMonitoredField(int field_id) {
        if (Config.isFeature("orglvl_analysis", false)) {
            return Utils.inArray(monitoredFieldIds, field_id);
        }
        return false;
    }

    static boolean isIncludedField(int field_id) {
        if (Config.isFeature("orglvl_analysis", false)) {
            return Utils.inArray(includedFieldIds, field_id);
        }
        return true;
    }

    static boolean isOrgLevelField(int field_id) {
        if (Config.isFeature("orglvl_analysis", false)) {
            return Utils.inArray(orgLevelFieldIds, field_id);
        }
        return false;
    }

    static void loadOrgLevels(String system, String client) {
        Log.log("OrgLevel loading fields for Organizational Levels.");
        ArrayList<Integer> monitored = new ArrayList<Integer>();
        ArrayList<Integer> included = new ArrayList<Integer>();
        ArrayList<Integer> allFields = new ArrayList<Integer>();
        ResultSet rs = DB.getData("SELECT field_id, include_empty, analysis FROM sod_analysis_varbl WHERE `system` = '" + system + "' AND `client` = '" + client + "';");
        try {
            while (rs.next()) {
                int field_id = rs.getInt("field_id");
                if (rs.getBoolean("analysis")) {
                    monitored.add(field_id);
                }
                if (rs.getBoolean("include_empty")) {
                    included.add(field_id);
                }
                allFields.add(field_id);
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("OrgLevelEntry.getCurrentMonitoredOrgLvls Failed to load monitored org lvls for analysis!");
            Log.logException(e);
        }
        if (monitoredFieldIds == null) {
            monitoredFieldIds = Utils.integerListToIntArray(monitored);
        }
        includedFieldIds = Utils.integerListToIntArray(included);
        orgLevelFieldIds = Utils.integerListToIntArray(allFields);
        Log.log("OrgLevel Organizational Levels monitored " + monitoredFieldIds.length + ".");
        Log.log("OrgLevel Organizational Levels included " + includedFieldIds.length + ".");
        Log.log("OrgLevel Organizational Levels existing " + orgLevelFieldIds.length + ".");
        isLoaded = true;
    }

    public static boolean isInList(Collection<Authorization> authorizationList, Authorization authorization) {
        for (Authorization a : authorizationList) {
            if (a.field_id != authorization.field_id || !a.low.contentEquals(authorization.low) || !a.high.contentEquals(authorization.high)) continue;
            return true;
        }
        return false;
    }
}

