/*
 * Decompiled with CFR 0.152.
 */
package ac.analysis;

import ac.analysis.AuthObject;
import java.util.HashMap;

public class Authorization {
    public static final Authorization[] EMPTYARRAY = new Authorization[0];
    static final String STJERNE = "*";
    static final int SIMPLE = 0;
    static final int SINGLE_WILDCARD = 1;
    static final int RANGE = 2;
    private static final HashMap<String, Authorization> createdAuthorizations = new HashMap();
    int authorizationType = 0;
    private int wildcardLPosition = -1;
    private int wildcardHPosition = -1;
    private final String prefixLow;
    private final String prefixHigh;
    public final int object_id;
    public final int field_id;
    public final String low;
    public final String high;
    public final Authorization[] listOfAuthorizations;
    private final HashMap<Authorization, Boolean> already_checked = new HashMap();
    private String toString = null;

    public static Authorization create(int object_id, int field_id, String low, String high) {
        String key;
        if (low.contentEquals(STJERNE)) {
            high = "";
        }
        if (!createdAuthorizations.containsKey(key = object_id + " " + field_id + " " + low + " " + high)) {
            createdAuthorizations.put(key, new Authorization(object_id, field_id, low, high));
        }
        return createdAuthorizations.get(key);
    }

    private Authorization(int object_id, int field_id, String low, String high) {
        this.object_id = object_id;
        this.field_id = field_id;
        this.low = low != null ? low : "";
        String string = this.high = high != null ? high : "";
        if (this.high.length() > 0) {
            this.authorizationType = 2;
            this.wildcardLPosition = this.low.indexOf(STJERNE);
            this.wildcardHPosition = this.high.indexOf(STJERNE);
            this.prefixLow = this.wildcardLPosition > 0 ? this.low.substring(0, this.wildcardLPosition) : this.low;
            this.prefixHigh = this.wildcardHPosition > 0 ? this.high.substring(0, this.wildcardHPosition) + "z" : this.high;
        } else if (this.low.contains(STJERNE)) {
            this.authorizationType = 1;
            this.wildcardLPosition = this.low.indexOf(STJERNE);
            this.prefixLow = this.wildcardLPosition > 0 ? this.low.substring(0, this.wildcardLPosition) : this.low;
            this.prefixHigh = this.high;
        } else {
            this.authorizationType = 0;
            this.prefixLow = this.low;
            this.prefixHigh = this.high;
        }
        this.listOfAuthorizations = null;
        this.already_checked.put(this, true);
    }

    public String toString() {
        if (this.toString == null) {
            String obj = AuthObject.getNameFromId(this.object_id);
            String fld = AuthObject.getFieldById(this.field_id);
            StringBuilder sb = new StringBuilder((String)(obj == null ? this.object_id + STJERNE : obj));
            sb.append(" ");
            sb.append("(");
            sb.append((String)(fld == null ? this.field_id + STJERNE : fld));
            sb.append(" ");
            sb.append(this.low);
            if (this.high.length() > 0) {
                sb.append("-" + this.high);
            }
            sb.append(")");
            this.toString = sb.toString();
        }
        return this.toString;
    }

    public static boolean isGranted(Authorization roleAuth, Authorization riskAuth) {
        if (riskAuth.already_checked.containsKey(roleAuth)) {
            return riskAuth.already_checked.get(roleAuth);
        }
        if (Authorization.check(roleAuth, riskAuth)) {
            riskAuth.already_checked.put(roleAuth, true);
            return true;
        }
        riskAuth.already_checked.put(roleAuth, false);
        return false;
    }

    private static boolean check(Authorization roleAuth, Authorization riskAuth) {
        if (riskAuth == roleAuth) {
            return true;
        }
        if (roleAuth.low.contentEquals(STJERNE) || roleAuth.high.contentEquals(STJERNE)) {
            return true;
        }
        switch (roleAuth.authorizationType) {
            case 0: {
                switch (riskAuth.authorizationType) {
                    case 0: {
                        return roleAuth.prefixLow.contentEquals(riskAuth.prefixLow);
                    }
                    case 2: {
                        return roleAuth.prefixLow.compareTo(riskAuth.prefixLow) >= 0 && roleAuth.prefixLow.compareTo(riskAuth.prefixHigh) <= 0;
                    }
                    case 1: {
                        if (riskAuth.prefixLow.length() > roleAuth.prefixLow.length()) {
                            return false;
                        }
                        return roleAuth.low.indexOf(riskAuth.prefixLow) == 0;
                    }
                }
            }
            case 1: {
                switch (riskAuth.authorizationType) {
                    case 0: {
                        if (roleAuth.prefixLow.length() > riskAuth.prefixLow.length()) {
                            return false;
                        }
                        return riskAuth.low.indexOf(roleAuth.prefixLow) == 0;
                    }
                    case 2: {
                        return riskAuth.prefixLow.compareTo(roleAuth.prefixLow) <= 0 && roleAuth.prefixLow.compareTo(riskAuth.prefixHigh) <= 0;
                    }
                    case 1: {
                        return riskAuth.prefixLow.compareTo(roleAuth.prefixLow) == 0;
                    }
                }
            }
            case 2: {
                switch (riskAuth.authorizationType) {
                    case 0: {
                        return riskAuth.prefixLow.compareTo(roleAuth.prefixLow) >= 0 && riskAuth.prefixLow.compareTo(roleAuth.prefixHigh) <= 0;
                    }
                    case 2: {
                        return riskAuth.prefixLow.compareTo(roleAuth.prefixLow) >= 0 && riskAuth.prefixLow.compareTo(roleAuth.prefixHigh) <= 0 || riskAuth.prefixHigh.compareTo(roleAuth.prefixLow) >= 0 && riskAuth.prefixHigh.compareTo(roleAuth.prefixHigh) <= 0 || roleAuth.prefixLow.compareTo(riskAuth.prefixLow) >= 0 && roleAuth.prefixLow.compareTo(riskAuth.prefixHigh) <= 0 || roleAuth.prefixHigh.compareTo(riskAuth.prefixLow) >= 0 && roleAuth.prefixHigh.compareTo(riskAuth.prefixHigh) <= 0;
                    }
                    case 1: {
                        if (riskAuth.prefixLow.length() > 0) {
                            return riskAuth.prefixLow.compareTo(roleAuth.prefixLow) >= 0 && riskAuth.prefixLow.compareTo(roleAuth.prefixHigh) <= 0;
                        }
                        return false;
                    }
                }
            }
        }
        return false;
    }
}

