/*
 * Decompiled with CFR 0.152.
 */
package ac.analysis;

import ac.analysis.AnalysisIterator;
import ac.analysis.AnalysisUser;
import ac.analysis.ViolationListener;
import ac.risk.Risk;
import ac.risk.Violation;
import cn.Log;
import cn.Memory;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class AnalyzeEngine {
    private static final String S_USER_RESULT = "Violations:\t%s\t%s\tviolations found in \t%s\trole(s), user %s .";
    private static final String S_STARTING_USER = "Violations:\t%s\tStarting new hash with %s";
    private static final ArrayList<Violation> CURRENT_tmp = new ArrayList();
    private static Violation[] CURRENT_VIOLATIONS = Violation.EMPTYARRAY;
    private static String CURRENT_HASH = "\t";
    private final Risk[] risks;
    private final AnalysisIterator analysisIterator;
    private int violationCount = 0;
    private int userViolationCount = 0;
    private final ArrayList<ViolationListener> listeners = new ArrayList();
    private long timecheck = 0L;
    private int userCount = 0;
    private boolean partial = false;
    private boolean lowMemory = false;
    private final ArrayList<ViolationListener> deadListeners = new ArrayList();

    public AnalyzeEngine(Risk[] risks, AnalysisIterator analysisIterator) {
        this.risks = risks;
        this.analysisIterator = analysisIterator;
        Thread.currentThread().setPriority(10);
        Log.log(Memory.statement("AnalyzeEngine set Thread priority to MAX_PRIORITY."));
    }

    public void analyze() {
        Log.log(Memory.statement(String.format("Starting analysis with %s risks and %s users for %s listeners.", this.risks.length, this.analysisIterator.getTotal(), this.listeners.size())));
        this.timecheck = System.nanoTime();
        if (this.analysisIterator.getTotal() > 0 && this.risks.length > 0 && this.listeners.size() > 0) {
            AnalyzeEngine.runAnalysis(this);
        } else {
            Log.log("NOTHING TO ANALYZE! Closing engine.");
            this.close();
        }
    }

    public void addListener(ViolationListener listener) {
        this.listeners.add(listener);
    }

    public boolean isPartial() {
        return this.partial;
    }

    public boolean isLowMemory() {
        return this.lowMemory;
    }

    public void close() {
        this.timecheck = System.nanoTime() - this.timecheck;
        Thread.currentThread().setPriority(5);
        Log.log(Memory.statement("Thread priority normalized post-analysis."));
        Log.log("Violations found in " + this.userCount + " of " + this.analysisIterator.getTotal() + " users processed for analysis.");
        long average = this.analysisIterator.getTotal() > 0 ? this.timecheck / (long)this.analysisIterator.getTotal() : 0L;
        Log.log("AnalyzeEngine found " + this.violationCount + " violations in " + this.userCount + " users while analysing " + this.analysisIterator.getTotal() + " users.");
        Log.log("AnalyzeEngine took " + TimeUnit.NANOSECONDS.toMillis(this.timecheck) + " ms, averaging to " + TimeUnit.NANOSECONDS.toMillis(average) + " ms per user.");
        Log.log("User iterator spent " + this.analysisIterator.getTimeSpentGettingUsers() + "ms serving user data.");
        Log.log("AuthorizationBag creation took: " + Risk.getTimeSpentMakingBags() + " ms.");
        Log.log("Closing listeners.");
        for (ViolationListener vl : this.listeners) {
            vl.close();
        }
        Log.log("Engine closed.");
    }

    private boolean distribute(AnalysisUser user, Violation[] violations, boolean copied) {
        for (ViolationListener vl : this.listeners) {
            if (vl.violationFound(user, violations)) continue;
            vl.close();
            this.deadListeners.add(vl);
            Log.log(String.format("Detaching listener %s", vl.getClass().getSimpleName()));
        }
        if (this.deadListeners.size() > 0) {
            Log.log(String.format("Removing %s listeners.", this.deadListeners.size()));
            this.listeners.removeAll(this.deadListeners);
            this.deadListeners.clear();
        }
        return this.listeners.size() > 0;
    }

    private static void runAnalysis(AnalyzeEngine engine) {
        boolean MemOk = Memory.ok4Analysis();
        boolean hasListeners = true;
        while (engine.analysisIterator.hasNext() && MemOk && hasListeners) {
            AnalysisUser analysisUser = engine.analysisIterator.nextUser();
            engine.userViolationCount = 0;
            if (analysisUser.hash.contentEquals(CURRENT_HASH)) {
                if (CURRENT_VIOLATIONS.length > 0) {
                    engine.violationCount += CURRENT_VIOLATIONS.length;
                    engine.userViolationCount += CURRENT_VIOLATIONS.length;
                    ++engine.userCount;
                }
            } else {
                CURRENT_HASH = analysisUser.hash;
                Log.debug(String.format(S_STARTING_USER, engine.violationCount, analysisUser.toString()));
                if (analysisUser.roles.length > 0) {
                    for (Risk risk : engine.risks) {
                        Violation violation = risk.checkViolations(analysisUser);
                        if (violation == null) continue;
                        ++engine.violationCount;
                        ++engine.userViolationCount;
                        CURRENT_tmp.add(violation);
                    }
                }
                if (CURRENT_tmp.size() > 0) {
                    CURRENT_VIOLATIONS = CURRENT_tmp.toArray(Violation.EMPTYARRAY);
                    CURRENT_tmp.clear();
                    ++engine.userCount;
                } else {
                    CURRENT_VIOLATIONS = Violation.EMPTYARRAY;
                }
            }
            if (!(hasListeners = engine.distribute(analysisUser, CURRENT_VIOLATIONS, true))) {
                Log.log(Memory.statement("Stopping analysis engine due to lack of listeners. No one is listening."));
                engine.partial = true;
                break;
            }
            MemOk = Memory.ok4Analysis();
            if (!MemOk) {
                Log.log(Memory.statement("Stopping analysis engine due to lack of memory."));
                engine.partial = true;
                engine.lowMemory = true;
                break;
            }
            Log.log(String.format(S_USER_RESULT, engine.violationCount, engine.userViolationCount, analysisUser.roles.length, analysisUser.toString()));
        }
        engine.close();
    }
}

