/*
 * Decompiled with CFR 0.152.
 */
package ac.analysis;

import ac.analysis.AnalysisRole;
import ac.analysis.ReferenceUser;
import cn.DB;
import cn.Log;
import cn.SapUser;
import cn.Utils;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public class AnalysisUser
extends SapUser {
    public static final AnalysisUser[] EMPTYARRAY = new AnalysisUser[0];
    private static long timeSpentLoading = 0L;
    public final boolean isDummyUser;
    public final boolean hasOrgLevels;
    public final AnalysisRole[] roles;
    public final String hash;
    public final String referenceUser;
    private static PreparedStatement PS_LOAD_AnalysisUser = null;

    public static long getTimeSpentLoading() {
        return TimeUnit.NANOSECONDS.toMillis(timeSpentLoading);
    }

    public AnalysisUser(String username, String system, String client, AnalysisRole role) {
        super(username, system, client);
        this.isDummyUser = true;
        this.referenceUser = "";
        this.id = 0;
        this.roles = new AnalysisRole[]{role};
        this.hash = "" + role.id;
        this.hasOrgLevels = role.hasOrgLvlAuthEntries;
    }

    protected AnalysisUser(int id, String username, String system, String client, String role_hash, String reference_user) {
        super(id, username, system, client);
        this.isDummyUser = false;
        if (!Utils.isEmpty(reference_user)) {
            String ru_hash = ReferenceUser.getReferenceUser(reference_user, this.system, this.client);
            if (!Utils.isEmpty(role_hash) && !Utils.isEmpty(ru_hash)) {
                role_hash = AnalysisUser.hash_merge(role_hash, ru_hash);
            } else if (Utils.isEmpty(role_hash) && !Utils.isEmpty(ru_hash)) {
                role_hash = ru_hash;
            }
            this.referenceUser = reference_user;
        } else {
            this.referenceUser = "";
        }
        this.roles = Utils.isEmpty(role_hash) ? AnalysisRole.EMPTY_ROLEARRAY : AnalysisRole.getRolesFromHash(role_hash);
        ArrayList<CallSite> hashData = new ArrayList<CallSite>();
        boolean hasOL = false;
        for (AnalysisRole r : this.roles) {
            if (r == null) {
                Log.log("Analysis user " + this.toString() + " found a NULL value role in " + this.roles.length + " roles.");
                continue;
            }
            if (r.hasOrgLvlAuthEntries) {
                hasOL = true;
                hashData.add((CallSite)((Object)("" + r.id)));
                continue;
            }
            hashData.add((CallSite)((Object)("" + r.id)));
        }
        this.hash = hashData.size() > 0 ? String.join((CharSequence)",", hashData.toArray(Utils.EMPTYSTRINGARRAY)) : "";
        this.hasOrgLevels = hasOL;
    }

    @Override
    public String toString() {
        if (this.isDummyUser) {
            return this.username + " (" + this.system + " / " + this.client + ") " + this.hash + "\t" + (Serializable)(this.roles[0].assignments >= 0 ? Integer.valueOf(this.roles[0].assignments) : "");
        }
        if (this.referenceUser.length() > 0) {
            return this.username + " (" + this.id + " " + this.system + " / " + this.client + ") " + this.referenceUser + ", " + this.hash;
        }
        return this.username + " (" + this.id + " " + this.system + " / " + this.client + ") " + this.hash;
    }

    public static final AnalysisUser getById(int user_id, String role_hash, String system, String client) {
        if (PS_LOAD_AnalysisUser == null) {
            PS_LOAD_AnalysisUser = DB.prepareStatement("SELECT \tum_user.user, um_user.ref_user, um_user.first_name, um_user.last_name,\n\tum_user.mail, um_user.user_group, um_user.license_type, um_user.locked, um_user.type\nFROM um_user\nWHERE um_user.id = ?;");
        }
        long startTime = System.nanoTime();
        try {
            PS_LOAD_AnalysisUser.setInt(1, user_id);
            ResultSet rs = PS_LOAD_AnalysisUser.executeQuery();
            if (rs.next()) {
                AnalysisUser au = new AnalysisUser(user_id, rs.getString(1), system, client, role_hash, rs.getString(2));
                au.setFirstName(rs.getString(3));
                au.setLastName(rs.getString(4));
                au.setMail(rs.getString(5));
                au.setUserGroup(rs.getString(6));
                au.setLicenseType(rs.getString(7));
                au.setLocked(rs.getString(8));
                au.setUserType(SapUser.getUserTypeText(rs.getString(9)));
                timeSpentLoading += System.nanoTime() - startTime;
                return au;
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("AnalysisUser getById FAILED for id " + user_id);
            Log.logException(e);
        }
        return null;
    }

    private static String hash_merge(String role_hash, String ref_hash) {
        Collection<Integer> role_ids = Utils.intArrayToIntegerList(Utils.getIdsFromString(role_hash));
        Collection<Integer> ref_ids = Utils.intArrayToIntegerList(Utils.getIdsFromString(ref_hash));
        Collection<Integer> new_ids = Utils.unique(Utils.mergeCollections(role_ids, ref_ids));
        return Utils.integerListToString(new_ids);
    }
}

