/*
 * Decompiled with CFR 0.152.
 */
package ac.analysis;

import ac.analysis.Authorization;
import ac.analysis.AuthorizationEntry;
import ac.analysis.OrgLevel;
import ac.analysis.OrgLevelAuthorization;
import cn.Config;
import cn.DB;
import cn.Log;
import cn.Role;
import cn.Utils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;

public class AnalysisRole
extends Role {
    private static final String S_REMOVING_DUPLICATE_ASSIGNMENTS = "Removing duplicate %s assignments ...";
    private static final String S_REMOVING_ASSIGNMENT = "Removing duplicate assignment %s";
    private static final String S_COMPOSITE_ADDING_ROLE = "Composite role %s added role %s.";
    public static final AnalysisRole[] EMPTY_ROLEARRAY = new AnalysisRole[0];
    private static final HashMap<Integer, AnalysisRole> loadedRoles = new HashMap();
    public final AuthorizationEntry[] authorizationEntries;
    public final AnalysisRole[] compositeChildren;
    public boolean hasOrgLvlAuthEntries = false;
    public int assignments = -1;
    private static final PreparedStatement LoadAuthorizations = DB.prepareStatement("SELECT sod_auth_object.id AS object_id, sod_auth_field.id AS field_id, low, high, auth, um_role_auth.field AS `field` FROM um_role_auth \nLEFT JOIN sod_auth_object ON sod_auth_object.object = um_role_auth.object AND sod_auth_object.system = ? AND sod_auth_object.client = ? \nLEFT JOIN sod_auth_field ON sod_auth_field.field = um_role_auth.field AND sod_auth_field.system = ? AND sod_auth_field.client = ? \nWHERE role_id = ? AND um_delete=0 AND IFNULL(CHAR_LENGTH(TRIM(low)), 0) > 0 ORDER BY auth, object_id, field_id;");
    private static final ArrayList<AuthorizationEntry> tmpEntries = new ArrayList();
    private static final ArrayList<Authorization> auths = new ArrayList();
    private static final ArrayList<OrgLevelAuthorization> olsds = new ArrayList();
    private static final PreparedStatement PS_ORG_LEVEL = DB.prepareStatement("SELECT varbl, low, high FROM um_role_org_lvl AS ro \nJOIN org_lvl AS o ON ro.org_lvl_id = o.id \nWHERE\tro.role_id = ? AND ro.um_delete=0 AND ro.system = ? AND ro.client = ? ;");
    private static final ArrayList<AuthorizationEntry> needsRemoval = new ArrayList();
    private static PreparedStatement PS_LOAD_CHILDREN = null;
    private static final ArrayList<AnalysisRole> children = new ArrayList();

    public static AnalysisRole create(int role_id, String name, String description, int sapStarCategory, boolean isComposite, String system, String client) {
        if (!loadedRoles.containsKey(role_id)) {
            AnalysisRole role = new AnalysisRole(role_id, name, description, sapStarCategory, isComposite, system, client);
            loadedRoles.put(role_id, role);
        }
        return loadedRoles.get(role_id);
    }

    public AnalysisRole(int id, String name, String description, int sapStarCategory, boolean isComposite, String system, String client) {
        super(id, name, description, isComposite, system, client);
        this.setSapStarStep(sapStarCategory);
        this.authorizationEntries = isComposite ? null : AnalysisRole.loadAuthorizations(this);
        this.compositeChildren = isComposite ? AnalysisRole.loadCompositeRoles(this, true) : null;
    }

    public static final AnalysisRole[] getRolesFromHash(String role_hash) {
        ArrayList<AnalysisRole> roles = new ArrayList<AnalysisRole>();
        int[] role_ids = Utils.getIdsFromString(role_hash);
        for (int i = 0; i < role_ids.length; ++i) {
            if (!loadedRoles.containsKey(role_ids[i])) {
                AnalysisRole.loadSingleId(role_ids[i]);
            }
            roles.add(loadedRoles.get(role_ids[i]));
        }
        ArrayList<AnalysisRole> duplicates = new ArrayList<AnalysisRole>();
        for (AnalysisRole ar : roles) {
            if (!ar.isComposite) continue;
            for (AnalysisRole cc : ar.compositeChildren) {
                if (!roles.contains(cc)) continue;
                duplicates.add(cc);
            }
        }
        if (duplicates.size() > 0) {
            Log.debug(String.format(S_REMOVING_DUPLICATE_ASSIGNMENTS, duplicates.size()));
            for (AnalysisRole r : duplicates) {
                Log.debug(String.format(S_REMOVING_ASSIGNMENT, r.toString()));
            }
            roles.removeAll(duplicates);
        }
        return roles.toArray(EMPTY_ROLEARRAY);
    }

    private static void loadSingleId(int id) {
        String idString = "'" + id + "'";
        PreparedStatement PS_load_role = DB.prepareStatement("SELECT id, `role`, `type`, `description`, `star_category_step`, `system`, `client` FROM um_role WHERE id IN (" + idString + ");");
        try {
            ResultSet rs = PS_load_role.executeQuery();
            while (rs.next()) {
                int role_id = rs.getInt(1);
                AnalysisRole.create(role_id, rs.getString("role"), rs.getString("description"), rs.getInt("star_category_step"), rs.getString("type").contentEquals("C"), rs.getString("system"), rs.getString("client"));
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("AnalysisRole failed at getRoles().");
            Log.logException(e);
        }
    }

    private static AuthorizationEntry[] loadAuthorizations(AnalysisRole role) {
        long start = System.nanoTime();
        tmpEntries.clear();
        auths.clear();
        try {
            LoadAuthorizations.setString(1, role.system);
            LoadAuthorizations.setString(2, role.client);
            LoadAuthorizations.setString(3, role.system);
            LoadAuthorizations.setString(4, role.client);
            LoadAuthorizations.setInt(5, role.id);
            ResultSet rs = LoadAuthorizations.executeQuery();
            String currentAuth = "";
            int current_object_id = -1;
            while (rs.next()) {
                String auth = rs.getString(5);
                int object_id = rs.getInt(1);
                if (!auth.contentEquals(currentAuth) || object_id != current_object_id) {
                    if (auths.size() > 0) {
                        AuthorizationEntry ae = new AuthorizationEntry(role, current_object_id, auths.toArray(Authorization.EMPTYARRAY));
                        tmpEntries.add(ae);
                        auths.clear();
                    }
                    currentAuth = auth;
                    current_object_id = object_id;
                }
                int field_id = rs.getInt(2);
                String low = rs.getString(3).trim();
                low = low.contentEquals("' '") ? "" : low;
                Authorization a = Authorization.create(object_id, field_id, low, rs.getString(4).trim());
                auths.add(a);
            }
            if (auths.size() > 0) {
                AuthorizationEntry ae = new AuthorizationEntry(role, current_object_id, auths.toArray(Authorization.EMPTYARRAY));
                tmpEntries.add(ae);
                auths.clear();
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("Failed while retrieving authorizations for role #" + role.id + " " + role.name);
            Log.logException(e);
        }
        timeSpentLoading += System.nanoTime() - start;
        return AnalysisRole.addOrgLvlAuthorizations(role);
    }

    private static AuthorizationEntry[] addOrgLvlAuthorizations(AnalysisRole role) {
        olsds.clear();
        try {
            PS_ORG_LEVEL.setInt(1, role.id);
            PS_ORG_LEVEL.setString(2, role.system);
            PS_ORG_LEVEL.setString(3, role.client);
            ResultSet rs = PS_ORG_LEVEL.executeQuery();
            while (rs.next()) {
                String low = rs.getString("low").trim();
                olsds.add(new OrgLevelAuthorization(rs.getString("varbl"), low, rs.getString("high").trim()));
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("AnalysisRole failed while adding addOrgLvlAuthorizations.");
            Log.logException(e);
        }
        ArrayList<Authorization> newValues = new ArrayList<Authorization>();
        ArrayList<OrgLevelAuthorization> tmpSwitched = new ArrayList<OrgLevelAuthorization>();
        for (OrgLevelAuthorization olsd : olsds) {
            for (AuthorizationEntry ae : tmpEntries) {
                for (int j = 0; j < ae.authorizations.length; ++j) {
                    if (!ae.authorizations[j].low.contentEquals(olsd.varbl)) continue;
                    if (Utils.isEmpty(olsd.low)) {
                        if (OrgLevel.isIncludedField(ae.authorizations[j].field_id)) continue;
                        needsRemoval.add(ae);
                        continue;
                    }
                    olsd.setFieldId(ae.authorizations[j].field_id);
                    Authorization newAuthorization = Authorization.create(ae.authorizations[j].object_id, ae.authorizations[j].field_id, olsd.low, olsd.high);
                    newValues.add(newAuthorization);
                    tmpSwitched.add(olsd);
                }
                if (newValues.size() <= 0 || needsRemoval.contains(ae)) continue;
                for (Authorization a : ae.authorizations) {
                    newValues.add(a);
                }
                AuthorizationEntry newAe = new AuthorizationEntry(role, ae.authObject_id, newValues.toArray(Authorization.EMPTYARRAY), tmpSwitched.size() > 0);
                tmpEntries.set(tmpEntries.indexOf(ae), newAe);
                newValues.clear();
                tmpSwitched.clear();
            }
            if (needsRemoval.size() <= 0) continue;
            Log.debug("Removing " + needsRemoval.size() + " authorization entries because no values was provided by org level field in " + role.name + " in AnalysisRole.addOrgLvlAuthorizations() 1");
            tmpEntries.removeAll(needsRemoval);
            needsRemoval.clear();
        }
        if (Config.isFeature("orglvl_analysis", false)) {
            ArrayList<Authorization> monitoredAuthorizations = new ArrayList<Authorization>();
            for (AuthorizationEntry ae : tmpEntries) {
                for (Authorization a : ae.authorizations) {
                    if (OrgLevel.isOrgLevelField(a.field_id) && !OrgLevel.isIncludedField(a.field_id) && (a.low.contains("$") && !ae.filled_by_varbl || Utils.isEmpty(a.low))) {
                        Log.debug("AnalysisRole.addOrgLvlAuthorizations removing " + ae.toString() + " because of " + a.toString());
                        needsRemoval.add(ae);
                        continue;
                    }
                    if (!OrgLevel.isMonitoredField(a.field_id) || a.low.contains("$") || a.low.contentEquals("*")) continue;
                    monitoredAuthorizations.add(a);
                }
                if (monitoredAuthorizations.size() <= 0 || needsRemoval.contains(ae)) continue;
                role.hasOrgLvlAuthEntries = true;
                ae.currentConflictingOrgLevelEntries = new ArrayList();
                ae.org_lvl_analysis = monitoredAuthorizations.toArray(Authorization.EMPTYARRAY);
                monitoredAuthorizations.clear();
            }
            if (needsRemoval.size() > 0) {
                Log.debug("Removing " + needsRemoval.size() + " authorization entries because no values was provided by org level field in " + role.name + " in AnalysisRole.addOrgLvlAuthorizations() 2");
                tmpEntries.removeAll(needsRemoval);
                needsRemoval.clear();
            }
        }
        return tmpEntries.toArray(AuthorizationEntry.EMPTYARRAY);
    }

    public static void loadIds(int[] role_ids, String system, String client) {
        if (role_ids.length > 0) {
            String idString = Utils.toQuotedString(role_ids);
            PreparedStatement PS_load_roles = DB.prepareStatement("SELECT id, `role`, `type`, `description`, `star_category_step` FROM um_role WHERE id IN (" + idString + ");");
            try {
                ResultSet rs = PS_load_roles.executeQuery();
                while (rs.next()) {
                    int role_id = rs.getInt(1);
                    AnalysisRole.create(role_id, rs.getString("role"), rs.getString("description"), rs.getInt("star_category_step"), rs.getString("type").contentEquals("C"), system, client);
                }
                rs.close();
            }
            catch (Exception e) {
                Log.log("AnalysisRole failed at getRoles().");
                Log.logException(e);
            }
        }
    }

    protected static AnalysisRole[] loadCompositeRoles(AnalysisRole composite_role, boolean keepRoles) {
        if (PS_LOAD_CHILDREN == null) {
            PS_LOAD_CHILDREN = DB.prepareStatement("SELECT r.id, r.role, r.description, r.star_category_step, r.system, r.client FROM um_role AS r JOIN um_role_comp AS rc ON rc.single = r.id AND rc.um_delete=0 AND r.um_delete = 0 WHERE rc.composite = ?;");
        }
        children.clear();
        try {
            PS_LOAD_CHILDREN.setInt(1, composite_role.id);
            ResultSet rs = PS_LOAD_CHILDREN.executeQuery();
            while (rs.next()) {
                if (keepRoles) {
                    children.add(AnalysisRole.create(rs.getInt("id"), rs.getString("role"), rs.getString("description"), rs.getInt("star_category_step"), false, rs.getString("system"), rs.getString("client")));
                    continue;
                }
                children.add(new AnalysisRole(rs.getInt("id"), rs.getString("role"), rs.getString("description"), rs.getInt("star_category_step"), false, rs.getString("system"), rs.getString("client")));
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("ac.analysis.AnalysisRole.loadCompositeRoles() FAILED to load children of composite role: " + composite_role.toString());
            Log.logException(e);
        }
        AnalysisRole[] singles = new AnalysisRole[children.size()];
        int i = 0;
        for (AnalysisRole single : children) {
            if (single != null) {
                singles[i++] = single;
                if (single.hasOrgLvlAuthEntries) {
                    composite_role.hasOrgLvlAuthEntries = true;
                }
                Log.log(String.format(S_COMPOSITE_ADDING_ROLE, composite_role.name, single.name));
                continue;
            }
            Log.log("Composite role " + composite_role.name + " tried to add NULL role ");
        }
        return singles;
    }

    @Override
    public String toString() {
        Object roles = "";
        if (this.isComposite) {
            roles = " (";
            for (AnalysisRole r : this.compositeChildren) {
                roles = (String)roles + r.toString() + ", ";
            }
            roles = (String)roles + ")";
        }
        return this.id + " " + this.name + " " + (this.isComposite ? "C" : "S") + " " + this.system + " / " + this.client + (String)roles;
    }
}

