/*
 * Decompiled with CFR 0.152.
 */
package ac;

import ac.dashboard.ViolationLegacy;
import ac.notification.NotificationTaskHandler;
import ac.risk.Approver;
import ac.risk.Risk;
import cn.DB;
import cn.Email;
import cn.Log;
import cn.Memory;
import cn.SapUser;
import cn.Utils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import org.json.JSONArray;

public class Workflow {
    public static final String STATUS_PENDING = "pending";
    public static final String STATUS_APPROVED = "approved";
    public static final String STATUS_REJECTED = "rejected";
    public static final String STATUS_CANCELLED = "cancelled";
    public static final String STATUS_AUTO_CANCELLED = "auto_cancelled";
    private String[] addrsApprovers;
    private String[] addrsUsers;
    private String[] addrsAdmin;
    private JSONArray approval_details;
    private String handle;
    private String status;
    private SapUser admin;
    private int violation_id;
    private int run;
    private boolean marked_seen;
    private boolean assigned;
    public String latestRun;
    public String latest_approval;
    public String first_approval;
    public String timestamp;
    private static final PreparedStatement PS_worflowByHandle = DB.prepareStatement("SELECT * FROM sod_workflow WHERE handle = ? ;");
    private static final PreparedStatement PS_saveWorkflow = DB.prepareStatement("INSERT INTO sod_workflow (`handle`, `system`, `client`, `admin`, `status`, `marked_seen`, `assigned`, `addrs_users`, `addrs_approvers`, `addrs_admin`, `approval_details`, `violation_id`, `run`, `first_approval`, `latest_approval`, `last_run_started`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) AS new_row ON DUPLICATE KEY UPDATE `admin` = new_row.admin, `status` = new_row.status, `marked_seen` = new_row.marked_seen, `assigned` = new_row.assigned, `addrs_users` = new_row.addrs_users, `addrs_approvers` = new_row.addrs_approvers, `addrs_admin` = new_row.addrs_admin, `run` = new_row.run, `first_approval` = new_row.first_approval, `approval_details` = new_row.approval_details, `latest_approval` = new_row.latest_approval, `last_run_started` = new_row.last_run_started;");

    public static void autoStartWorkFlow(SapUser legacy_user, int legacy_id, Risk risk, String handle) {
        Log.log(Memory.statement("Autostarting workflow for risk legacy " + legacy_id + ", " + risk.toString() + ", " + legacy_user.toString()));
        String[] admin_addr = new String[]{Email.getFromAC(legacy_user.system, legacy_user.client)};
        SapUser user = new SapUser("AC_autostart", legacy_user.system, legacy_user.client);
        String legacy_handle = legacy_user.system + "_" + legacy_user.client + "_" + legacy_id;
        String[] user_addrs = DB.getOneTextColumn("SELECT mail FROM um_user WHERE `system` = '" + legacy_user.system + "' AND `client` = '" + legacy_user.client + "' AND `user` = '" + legacy_user.username + "' ;");
        Approver[] approvers = risk.getMultiApprovers();
        String[] appr_addrs = new String[approvers.length];
        int i = 0;
        for (Approver approver : approvers) {
            if (approver != null) {
                if (!Utils.isEmpty(approver.email)) {
                    appr_addrs[i] = approver.email;
                    continue;
                }
                Log.log("Workflow.autoStartWorkFlow found no email for approver " + approver.toString());
                continue;
            }
            Log.log("Workflow.autoStartWorkFlow somehow got a NULL approver.\napprover count: " + approvers.length + "\nexpected count: " + risk.multi_approver.length + "\ncontent of var: " + Utils.integerListToString(Utils.intArrayToIntegerList(risk.multi_approver)));
        }
        appr_addrs = Utils.unique(appr_addrs);
        Log.log(Memory.statement("Trying to create legacy workflow for legacy " + legacy_id));
        Workflow workflow = new Workflow(user, legacy_handle, legacy_id);
        workflow.start(user_addrs, appr_addrs, admin_addr, true, risk);
        if (appr_addrs.length > 0) {
            user = new SapUser(approvers[0].getUser(), legacy_user.system, legacy_user.client);
        }
        if (!Utils.isEmpty(workflow.getHandle())) {
            NotificationTaskHandler.scheduleWorkflowNotification(workflow.getHandle(), user);
            ViolationLegacy.updateHandle(legacy_id, workflow.getHandle(), workflow.admin.system, workflow.admin.client);
            Log.log("Workflow created for legacy id " + legacy_id + " with handle '" + workflow.getHandle() + "'.");
        } else {
            Log.log("TRIED to create workflow legacy id " + legacy_id + " with handle '" + handle + "' but no handle was returned.");
        }
    }

    public Workflow(SapUser admin, String handle, int legacy_id) {
        this.admin = admin;
        this.handle = handle;
        this.violation_id = legacy_id;
    }

    public String getStatus() {
        return this.status;
    }

    public String getHandle() {
        return this.handle;
    }

    public JSONArray getApprovalDetails() {
        return this.approval_details;
    }

    public String[] getMailAddrApprovers() {
        return this.addrsApprovers;
    }

    public String[] getAddrAdmins() {
        return this.addrsAdmin;
    }

    public String get_timestamp() {
        return this.timestamp;
    }

    public String[] getMailAddrUsers() {
        if (this.addrsUsers != null) {
            return this.addrsUsers;
        }
        Log.log("user email not set");
        return new String[0];
    }

    public SapUser getAdmin() {
        return this.admin;
    }

    public int getViolationId() {
        return this.violation_id;
    }

    public boolean isLegacy() {
        return this.violation_id > 0;
    }

    public boolean isPending() {
        return this.status.equalsIgnoreCase(STATUS_PENDING);
    }

    public String getLastRejected() {
        String timestamp = DB.getOne("SELECT `timestamp` FROM sod_workflow_approval WHERE `action` = 'rejected' AND handle = '" + this.handle + "' ORDER BY `timestamp` DESC LIMIT 1;");
        if (Utils.isEmpty(timestamp)) {
            timestamp = "0001-01-01 00:00:00";
        }
        return timestamp;
    }

    public void start(String[] user_addrs, String[] approver_addrs, String[] admin_addr, boolean allready_assigned, Risk risk) {
        this.addrsUsers = user_addrs;
        this.addrsApprovers = approver_addrs;
        this.addrsAdmin = admin_addr;
        if (this.isFirstRun()) {
            this.assigned = allready_assigned;
        }
        this.marked_seen = false;
        this.status = STATUS_PENDING;
        ++this.run;
        if (this.run > 1) {
            DB.update("UPDATE `sod_workflow` SET `last_run_started` = CURRENT_TIMESTAMP WHERE `handle` = '" + this.handle + "'; ");
        }
        this.calculateApprovalDetails(risk);
        Calendar cal = Calendar.getInstance();
        String ts = new Timestamp(cal.getTime().getTime()).toString();
        this.latestRun = ts.substring(0, ts.lastIndexOf("."));
        this.save();
    }

    private void calculateApprovalDetails(Risk risk) {
        Approver[] approvers = risk.getMultiApprovers();
        CharSequence[] approverData = new String[approvers.length];
        int i = 0;
        for (Approver approver : approvers) {
            approverData[i++] = "{\"approverText\":\"" + approver.approver + "\",\"username\":\"" + approver.user + "\",\"substitute\":\"" + approver.substitute + "\",\"system\":\"" + approver.system + "\",\"client\":\"" + approver.client + "\",\"email\":\"" + approver.email + "\"}";
        }
        this.approval_details = Workflow.parseDetails("[{\"ruleId\":" + risk.id + ",\"violation\":" + this.getViolationId() + ",\"minApprovers\":" + risk.approver_minimum + ",\"approvers\":[" + String.join((CharSequence)",", approverData) + "]}]");
    }

    private boolean isFirstRun() {
        Workflow workflow = Workflow.getWorkflowFromHandle(this.handle);
        if (workflow == null) {
            if (this.isLegacy()) {
                if (!Utils.isEmpty(ViolationLegacy.getHandle(this.violation_id, this.admin.system, this.admin.client))) {
                    workflow = Workflow.getWorkflowFromHandle(this.handle);
                    if (workflow != null) {
                        this.assigned = workflow.assigned;
                        this.marked_seen = workflow.marked_seen;
                        this.run = workflow.run;
                        this.first_approval = workflow.first_approval;
                        this.latest_approval = workflow.latest_approval;
                        return false;
                    }
                    return true;
                }
                return true;
            }
            return true;
        }
        this.assigned = workflow.assigned;
        this.marked_seen = workflow.marked_seen;
        this.run = workflow.run;
        this.first_approval = workflow.first_approval;
        this.latest_approval = workflow.latest_approval;
        return false;
    }

    private static JSONArray parseDetails(String jsonString) {
        try {
            JSONArray details = new JSONArray(jsonString);
            return details;
        }
        catch (Exception e) {
            Log.log("AC/Notification Workflow.java failed to convert database causes to JSON Array format");
            Log.logException(e);
            return null;
        }
    }

    private void save() {
        String users = new JSONArray((Object)this.addrsUsers).toString();
        String approvers = new JSONArray((Object)this.addrsApprovers).toString();
        String admins = new JSONArray((Object)this.addrsAdmin).toString();
        String details = this.approval_details.toString();
        try {
            PS_saveWorkflow.setString(1, this.handle);
            PS_saveWorkflow.setString(2, this.admin.system);
            PS_saveWorkflow.setString(3, this.admin.client);
            PS_saveWorkflow.setString(4, this.admin.getUserName());
            PS_saveWorkflow.setString(5, this.status);
            PS_saveWorkflow.setString(6, this.marked_seen ? "true" : "false");
            PS_saveWorkflow.setString(7, this.assigned ? "true" : "false");
            PS_saveWorkflow.setString(8, users);
            PS_saveWorkflow.setString(9, approvers);
            PS_saveWorkflow.setString(10, admins);
            PS_saveWorkflow.setString(11, details);
            PS_saveWorkflow.setInt(12, this.violation_id);
            PS_saveWorkflow.setInt(13, this.run);
            PS_saveWorkflow.setString(14, this.first_approval);
            PS_saveWorkflow.setString(15, this.latest_approval);
            PS_saveWorkflow.setTimestamp(16, Timestamp.valueOf(this.latestRun));
            PS_saveWorkflow.executeUpdate();
        }
        catch (Exception e) {
            Log.log("AC Workflow save, failed to update database table");
            Log.logException(e);
        }
    }

    public static Workflow getWorkflowFromHandle(String handle) {
        Workflow workflow = null;
        try {
            PS_worflowByHandle.setString(1, handle);
            ResultSet rs = PS_worflowByHandle.executeQuery();
            if (rs.next()) {
                SapUser sapAdmin = new SapUser(rs.getString("admin"), rs.getString("system"), rs.getString("client"));
                workflow = new Workflow(sapAdmin, handle, rs.getInt("violation_id"));
                workflow.addrsUsers = rs.getString("addrs_users").replaceAll("[\\[\\]\"]", "").split(",");
                workflow.addrsApprovers = rs.getString("addrs_approvers").replaceAll("[\\[\\]\"]", "").split(",");
                workflow.addrsAdmin = rs.getString("addrs_admin").replaceAll("[\\[\\]\"]", "").split(",");
                workflow.approval_details = Workflow.parseDetails(rs.getString("approval_details"));
                workflow.marked_seen = rs.getString("marked_seen").equals("true");
                workflow.assigned = rs.getString("assigned").equals("true");
                workflow.run = rs.getInt("run");
                workflow.first_approval = rs.getString("first_approval");
                workflow.latest_approval = rs.getString("latest_approval");
                workflow.timestamp = rs.getString("created");
                workflow.status = rs.getString("status");
                workflow.latestRun = rs.getString("last_run_started");
            }
            rs.close();
        }
        catch (Exception e) {
            Log.log("ac.notification.Workflow getWorkflowFromHandle loading workflow FAILED!");
            Log.logException(e);
        }
        return workflow;
    }

    public String toString() {
        return this.handle + "\n" + this.run + "\n" + this.latestRun + "\n" + this.first_approval + "\n" + this.latest_approval + "\n" + this.getLastRejected() + "\n" + this.status + "\n" + this.timestamp + "\n" + this.get_timestamp() + "\n";
    }
}

