/*
 * Decompiled with CFR 0.152.
 */
package ac;

import ac.report.tools.Settings;
import cn.Arguments;
import cn.Config;
import cn.DB;
import cn.Email;
import cn.Log;
import cn.SapUser;
import cn.Translator;
import cn.report.ReportStarter;
import cn.task.Task;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EmailReports {
    public static void main(String[] args) {
        Arguments myArgs = Arguments.handle(args);
        String system = myArgs.get("system");
        String client = myArgs.get("client");
        Log.log("Starting EmailReports for " + system + " / " + client);
        EmailReports.go(system, client);
        Log.log("Ending EmailReports for " + system + " / " + client);
        DB.close();
        Log.close();
    }

    private static void go(String system, String client) {
        int id;
        PreparedStatement ps_get = DB.prepareStatement("SELECT * FROM queued_reports WHERE `system` = ? AND client = ? ORDER BY `user`, `report_id`;");
        ArrayList<Integer> processedIds = new ArrayList<Integer>();
        HashMap<Integer, SapUser> data = new HashMap<Integer, SapUser>();
        try {
            ps_get.setString(1, system);
            ps_get.setString(2, client);
            ResultSet rs = ps_get.executeQuery();
            while (rs.next()) {
                SapUser su = new SapUser(rs.getString("user"), system, client);
                int report_id = rs.getInt("report_id");
                data.put(report_id, su);
                id = rs.getInt("id");
                processedIds.add(id);
                Log.log("Found " + id + " w " + report_id + " for " + su.toString() + " @ " + su.getEmail());
            }
            rs.close();
        }
        catch (SQLException e) {
            Log.log("ac.EmailReports could not get reports.");
        }
        Log.log("Found " + data.size() + " reports in " + processedIds.size() + " entries.");
        for (Map.Entry entry : data.entrySet()) {
            SapUser su = (SapUser)entry.getValue();
            if (Email.isValidEmail(su.getEmail())) {
                Log.log(su.toString() + " does have a valid email address to mail report " + entry.getKey() + " to (" + su.getEmail() + ").");
                EmailReports.sendReport((Integer)entry.getKey(), (SapUser)entry.getValue());
                continue;
            }
            Log.log(su.toString() + " does not have a valid email address to mail report " + entry.getKey() + " to (" + su.getEmail() + ").");
        }
        if (processedIds.size() > 0) {
            CharSequence[] ids = new String[processedIds.size()];
            int i = 0;
            Iterator iterator = processedIds.iterator();
            while (iterator.hasNext()) {
                id = (Integer)iterator.next();
                ids[i++] = "" + id;
            }
            DB.update("DELETE FROM queued_reports WHERE id IN (" + String.join((CharSequence)",", ids) + ");");
        }
    }

    private static void sendReport(int report_id, SapUser su) {
        Task task = Task.getById(report_id);
        Settings params = new Settings(task.params);
        Translator translator = Translator.getInstance(params.getLanguageISO());
        String fileType = params.isExcel() ? ".xlsx" : ".csv";
        String filename = Config.getReportPath() + ReportStarter.getBaseFilename(task.type, task.id) + fileType;
        String reportName = task.getAttributes().getString("name");
        String from = Email.getFromAC(su.system, su.client);
        String subject = translator.getText("AC Scheduled report '{1}'", new String[]{reportName});
        String body = "<h1>" + translator.getText("Report") + " '" + reportName + "'</h1><p>" + translator.getText("Scheduled by {1}", new String[]{su.toString()}) + "</p>";
        Email email = new Email(from, Email.convertEmailString(su.getEmail()), subject, body);
        email.attachFile(filename);
        email.send();
    }
}

